/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.seasons;

import javax.annotation.Nonnull;
import net.minecraft.world.World;
import org.orecruncher.lib.Localization;
import org.orecruncher.lib.compat.ModEnvironment;
import org.orecruncher.lib.seasons.SeasonSubType;
import org.orecruncher.lib.seasons.SeasonType;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.SeasonHelper;

public enum Season {
    NONE(SeasonType.NONE, SeasonSubType.NONE),
    EARLY_SPRING(SeasonType.SPRING, SeasonSubType.EARLY),
    MID_SPRING(SeasonType.SPRING, SeasonSubType.MID),
    LATE_SPRING(SeasonType.SPRING, SeasonSubType.LATE),
    EARLY_SUMMER(SeasonType.SUMMER, SeasonSubType.EARLY),
    MID_SUMMER(SeasonType.SUMMER, SeasonSubType.MID),
    LATE_SUMMER(SeasonType.SUMMER, SeasonSubType.LATE),
    EARLY_AUTUMN(SeasonType.AUTUMN, SeasonSubType.EARLY),
    MID_AUTUMN(SeasonType.AUTUMN, SeasonSubType.MID),
    LATE_AUTUMN(SeasonType.AUTUMN, SeasonSubType.LATE),
    EARLY_WINTER(SeasonType.WINTER, SeasonSubType.EARLY),
    MID_WINTER(SeasonType.WINTER, SeasonSubType.MID),
    LATE_WINTER(SeasonType.WINTER, SeasonSubType.LATE);

    private static final String FORMAT_NONE = "sndctrl.season.noseason";
    private static final String FORMAT_STRING = "sndctrl.season.format";
    private static final ISeasonHelper SEASON_HELPER;
    private final SeasonType season;
    private final SeasonSubType subType;

    private Season(SeasonType type, SeasonSubType subType) {
        this.season = type;
        this.subType = subType;
    }

    @Nonnull
    public SeasonType getType() {
        return this.season;
    }

    @Nonnull
    public SeasonSubType getSubType() {
        return this.subType;
    }

    @Nonnull
    public static Season getSeason(@Nonnull World world) {
        return SEASON_HELPER.getSeason(world);
    }

    @Nonnull
    private static Season getSereneSeason(@Nonnull World world) {
        Season season = NONE;
        ISeasonState state = SeasonHelper.getSeasonState((World)world);
        if (state != null) {
            switch (state.getSubSeason()) {
                case EARLY_SPRING: {
                    season = EARLY_SPRING;
                    break;
                }
                case MID_SPRING: {
                    season = MID_SPRING;
                    break;
                }
                case LATE_SPRING: {
                    season = LATE_SPRING;
                    break;
                }
                case EARLY_SUMMER: {
                    season = EARLY_SUMMER;
                    break;
                }
                case MID_SUMMER: {
                    season = MID_SUMMER;
                    break;
                }
                case LATE_SUMMER: {
                    season = LATE_SUMMER;
                    break;
                }
                case EARLY_AUTUMN: {
                    season = EARLY_AUTUMN;
                    break;
                }
                case MID_AUTUMN: {
                    season = MID_AUTUMN;
                    break;
                }
                case LATE_AUTUMN: {
                    season = LATE_AUTUMN;
                    break;
                }
                case EARLY_WINTER: {
                    season = EARLY_WINTER;
                    break;
                }
                case MID_WINTER: {
                    season = MID_WINTER;
                    break;
                }
                case LATE_WINTER: {
                    season = LATE_WINTER;
                }
            }
        }
        return season;
    }

    @Nonnull
    public String getFormattedText() {
        if (this.season == SeasonType.NONE) {
            return Localization.load(FORMAT_NONE);
        }
        return Localization.format(FORMAT_STRING, this.subType.getFormattedText(), this.season.getFormattedText());
    }

    static {
        SEASON_HELPER = ModEnvironment.SereneSeasons.isLoaded() ? Season::getSereneSeason : world -> NONE;
    }

    private static interface ISeasonHelper {
        public Season getSeason(@Nonnull World var1);
    }
}

