/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.effects;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.TickCounter;
import org.orecruncher.mobeffects.effects.FactoryHandler;
import org.orecruncher.mobeffects.library.ItemData;
import org.orecruncher.mobeffects.library.ItemLibrary;
import org.orecruncher.sndctrl.api.effects.AbstractEntityEffect;

@Mod.EventBusSubscriber(modid="mobeffects", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EntitySwingEffect
extends AbstractEntityEffect {
    private static final long RIGHT_CLICK_GRACE = 5L;
    private static final ResourceLocation NAME = new ResourceLocation("mobeffects", "swing");
    public static final FactoryHandler FACTORY = new FactoryHandler(NAME, entity -> new EntitySwingEffect());
    private static long lastRightClick;
    protected int swingProgress = 0;
    protected boolean isSwinging = false;

    public EntitySwingEffect() {
        super(NAME);
    }

    @Override
    public void update() {
        LivingEntity entity = this.getEntity();
        if (entity.func_184187_bx() instanceof BoatEntity) {
            return;
        }
        if (entity.field_110158_av > this.swingProgress && entity.field_184622_au != null) {
            if (!this.isSwinging && this.isClickOK(entity) && EntitySwingEffect.freeSwing(entity)) {
                ItemStack currentItem = entity.func_184586_b(entity.field_184622_au);
                ItemData data = ItemLibrary.getItemData(currentItem);
                if (this.isActivePlayer(entity)) {
                    data.playSwingSound();
                } else {
                    data.playSwingSound(entity.func_233580_cy_());
                }
            }
            this.isSwinging = true;
        } else {
            this.isSwinging = false;
        }
        this.swingProgress = entity.field_110158_av;
    }

    protected static boolean freeSwing(@Nonnull LivingEntity entity) {
        BlockRayTraceResult result = EntitySwingEffect.rayTraceBlock(entity);
        return result.func_216346_c() == RayTraceResult.Type.MISS;
    }

    protected static double getReach(@Nonnull LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            return entity.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        }
        return entity.func_213311_cf() * 2.0f + 0.6f;
    }

    protected static BlockRayTraceResult rayTraceBlock(@Nonnull LivingEntity entity) {
        double range = EntitySwingEffect.getReach(entity);
        Vector3d eyes = entity.func_174824_e(1.0f);
        Vector3d look = entity.func_70676_i(1.0f);
        Vector3d rangedLook = eyes.func_72441_c(look.field_72450_a * range, look.field_72448_b * range, look.field_72449_c * range);
        return entity.func_130014_f_().func_217299_a(new RayTraceContext(eyes, rangedLook, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.SOURCE_ONLY, (Entity)entity));
    }

    private boolean isClickOK(@Nonnull LivingEntity entity) {
        return entity == GameUtils.getPlayer() && lastRightClick < TickCounter.getTickCount() - 5L;
    }

    @SubscribeEvent
    public static void onRightClick(@Nonnull PlayerInteractEvent.RightClickBlock event) {
        if (event.getSide() == LogicalSide.CLIENT) {
            lastRightClick = TickCounter.getTickCount();
        }
    }
}

