/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.footsteps;

import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.mobeffects.footsteps.FootStrikeLocation;
import org.orecruncher.sndctrl.api.acoustics.AcousticEvent;
import org.orecruncher.sndctrl.api.acoustics.IAcoustic;
import org.orecruncher.sndctrl.audio.acoustic.AcousticCompiler;

@OnlyIn(value=Dist.CLIENT)
public class Association {
    private final FootStrikeLocation location;
    private IAcoustic data;

    public Association(@Nonnull LivingEntity entity, @Nonnull IAcoustic association) {
        Vector3d vec = entity.func_213303_ch();
        this.location = new FootStrikeLocation(entity, vec.field_72450_a, vec.field_72448_b + 1.0, vec.field_72449_c);
        this.data = association;
    }

    public Association(@Nonnull FootStrikeLocation pos, @Nonnull IAcoustic association) {
        this.location = pos;
        this.data = association;
    }

    public void merge(IAcoustic ... acoustics) {
        IAcoustic[] t = new IAcoustic[1 + acoustics.length];
        t[0] = this.data;
        System.arraycopy(acoustics, 0, t, 1, acoustics.length);
        this.data = AcousticCompiler.combine(t);
    }

    public void play(@Nonnull AcousticEvent event) {
        this.data.playAt(this.location.getStrikePosition(), event);
    }

    @Nonnull
    public FootStrikeLocation getStrikeLocation() {
        return this.location;
    }

    @Nonnull
    public BlockPos getStepPos() {
        return this.location.getStepPos();
    }
}

