/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal;

import codechicken.lib.datagen.LanguageProvider;
import codechicken.lib.util.CCLTags;
import net.minecraft.block.Blocks;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.ItemTagsProvider;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(modid="codechickenlib", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherDataGenerators(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper files = event.getExistingFileHelper();
        if (event.includeServer()) {
            BlockTags blockTagsProvider = new BlockTags(gen, files);
            gen.func_200390_a((IDataProvider)blockTagsProvider);
            gen.func_200390_a((IDataProvider)new ItemTags(gen, blockTagsProvider, files));
        }
        if (event.includeClient() || event.includeServer()) {
            gen.func_200390_a((IDataProvider)new LangUS(gen, LanguageProvider.getDist(event)));
        }
    }

    public static class LangUS
    extends LanguageProvider {
        public LangUS(DataGenerator gen, LanguageProvider.Side side) {
            super(gen, "codechickenlib", "en_us", side);
        }

        @Override
        protected void addTranslations() {
            this.addServer("ccl.commands.gc.before", "Before:");
            this.addServer("ccl.commands.gc.performing", "Performing GC..");
            this.addServer("ccl.commands.gc.after", "After:");
            this.addServer("ccl.commands.killall.fail", "Found no entities.");
            this.addServer("ccl.commands.killall.fail.player", "You cannot kill players with this command.");
            this.addServer("ccl.commands.killall.success", "Killed %s entities.");
            this.addServer("ccl.commands.killall.success.line", "Killed %s");
            this.addServer("ccl.commands.count.fail", "Found no entities.");
            this.addServer("ccl.commands.count.total", "Found %s entities.");
        }
    }

    private static class ItemTags
    extends ItemTagsProvider {
        public ItemTags(DataGenerator generatorIn, BlockTags blockTagProvider, ExistingFileHelper files) {
            super(generatorIn, (BlockTagsProvider)blockTagProvider, "codechickenlib", files);
        }

        protected void func_200432_c() {
            this.func_240522_a_((ITag.INamedTag)CCLTags.Items.WOOL).func_240531_a_(CCLTags.Items.WOOL_WHITE).func_240531_a_(CCLTags.Items.WOOL_ORANGE).func_240531_a_(CCLTags.Items.WOOL_MAGENTA).func_240531_a_(CCLTags.Items.WOOL_LIGHT_BLUE).func_240531_a_(CCLTags.Items.WOOL_YELLOW).func_240531_a_(CCLTags.Items.WOOL_LIME).func_240531_a_(CCLTags.Items.WOOL_PINK).func_240531_a_(CCLTags.Items.WOOL_GRAY).func_240531_a_(CCLTags.Items.WOOL_LIGHT_GRAY).func_240531_a_(CCLTags.Items.WOOL_CYAN).func_240531_a_(CCLTags.Items.WOOL_PURPLE).func_240531_a_(CCLTags.Items.WOOL_BLUE).func_240531_a_(CCLTags.Items.WOOL_BROWN).func_240531_a_(CCLTags.Items.WOOL_GREEN).func_240531_a_(CCLTags.Items.WOOL_RED).func_240531_a_(CCLTags.Items.WOOL_BLACK);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Items.WOOL_WHITE).func_240532_a_((Object)Items.field_221603_aE);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Items.WOOL_ORANGE).func_240532_a_((Object)Items.field_221604_aF);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Items.WOOL_MAGENTA).func_240532_a_((Object)Items.field_221605_aG);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Items.WOOL_LIGHT_BLUE).func_240532_a_((Object)Items.field_221606_aH);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Items.WOOL_YELLOW).func_240532_a_((Object)Items.field_221607_aI);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Items.WOOL_LIME).func_240532_a_((Object)Items.field_221608_aJ);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Items.WOOL_PINK).func_240532_a_((Object)Items.field_221609_aK);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Items.WOOL_GRAY).func_240532_a_((Object)Items.field_221610_aL);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Items.WOOL_LIGHT_GRAY).func_240532_a_((Object)Items.field_221611_aM);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Items.WOOL_CYAN).func_240532_a_((Object)Items.field_221612_aN);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Items.WOOL_PURPLE).func_240532_a_((Object)Items.field_221613_aO);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Items.WOOL_BLUE).func_240532_a_((Object)Items.field_221614_aP);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Items.WOOL_BROWN).func_240532_a_((Object)Items.field_221615_aQ);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Items.WOOL_GREEN).func_240532_a_((Object)Items.field_221616_aR);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Items.WOOL_RED).func_240532_a_((Object)Items.field_221617_aS);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Items.WOOL_BLACK).func_240532_a_((Object)Items.field_221618_aT);
        }

        public String func_200397_b() {
            return "CodeChickenLib Item tags.";
        }
    }

    private static class BlockTags
    extends BlockTagsProvider {
        public BlockTags(DataGenerator generatorIn, ExistingFileHelper files) {
            super(generatorIn, "codechickenlib", files);
        }

        protected void func_200432_c() {
            this.func_240522_a_((ITag.INamedTag)CCLTags.Blocks.WOOL).func_240531_a_(CCLTags.Blocks.WOOL_WHITE).func_240531_a_(CCLTags.Blocks.WOOL_ORANGE).func_240531_a_(CCLTags.Blocks.WOOL_MAGENTA).func_240531_a_(CCLTags.Blocks.WOOL_LIGHT_BLUE).func_240531_a_(CCLTags.Blocks.WOOL_YELLOW).func_240531_a_(CCLTags.Blocks.WOOL_LIME).func_240531_a_(CCLTags.Blocks.WOOL_PINK).func_240531_a_(CCLTags.Blocks.WOOL_GRAY).func_240531_a_(CCLTags.Blocks.WOOL_LIGHT_GRAY).func_240531_a_(CCLTags.Blocks.WOOL_CYAN).func_240531_a_(CCLTags.Blocks.WOOL_PURPLE).func_240531_a_(CCLTags.Blocks.WOOL_BLUE).func_240531_a_(CCLTags.Blocks.WOOL_BROWN).func_240531_a_(CCLTags.Blocks.WOOL_GREEN).func_240531_a_(CCLTags.Blocks.WOOL_RED).func_240531_a_(CCLTags.Blocks.WOOL_BLACK);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Blocks.WOOL_WHITE).func_240532_a_((Object)Blocks.field_196556_aL);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Blocks.WOOL_ORANGE).func_240532_a_((Object)Blocks.field_196557_aM);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Blocks.WOOL_MAGENTA).func_240532_a_((Object)Blocks.field_196558_aN);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Blocks.WOOL_LIGHT_BLUE).func_240532_a_((Object)Blocks.field_196559_aO);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Blocks.WOOL_YELLOW).func_240532_a_((Object)Blocks.field_196560_aP);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Blocks.WOOL_LIME).func_240532_a_((Object)Blocks.field_196561_aQ);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Blocks.WOOL_PINK).func_240532_a_((Object)Blocks.field_196562_aR);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Blocks.WOOL_GRAY).func_240532_a_((Object)Blocks.field_196563_aS);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Blocks.WOOL_LIGHT_GRAY).func_240532_a_((Object)Blocks.field_196564_aT);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Blocks.WOOL_CYAN).func_240532_a_((Object)Blocks.field_196565_aU);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Blocks.WOOL_PURPLE).func_240532_a_((Object)Blocks.field_196566_aV);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Blocks.WOOL_BLUE).func_240532_a_((Object)Blocks.field_196567_aW);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Blocks.WOOL_BROWN).func_240532_a_((Object)Blocks.field_196568_aX);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Blocks.WOOL_GREEN).func_240532_a_((Object)Blocks.field_196569_aY);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Blocks.WOOL_RED).func_240532_a_((Object)Blocks.field_196570_aZ);
            this.func_240522_a_((ITag.INamedTag)CCLTags.Blocks.WOOL_BLACK).func_240532_a_((Object)Blocks.field_196602_ba);
        }

        public String func_200397_b() {
            return "CodeChickenLib Block tags.";
        }
    }
}

