/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.registry.trade.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class OfferMixingContext {
    private int currentIndex = 0;
    private final int maxOffers;
    private final Iterator<Integer> iterator;
    private final VillagerTrades.ITrade[] itemListings;
    private final Random random;

    public OfferMixingContext(int maxOffers, VillagerTrades.ITrade[] itemListings, Random random) {
        this.maxOffers = Math.min(maxOffers, itemListings.length);
        this.itemListings = itemListings;
        this.random = random;
        List<Integer> shuffled = this.createShuffledIndexList();
        this.iterator = shuffled.iterator();
    }

    public void skipIteratorIfMaxOffersReached() {
        ++this.currentIndex;
        if (this.currentIndex >= this.getMaxOffers()) {
            this.skip();
        }
    }

    @NotNull
    public Iterator<Integer> getIterator() {
        return this.iterator;
    }

    private void skip() {
        this.iterator.forEachRemaining($ -> {});
    }

    @NotNull
    private List<Integer> createShuffledIndexList() {
        ArrayList<Integer> shuffledListings = new ArrayList<Integer>();
        for (int i = 0; i < this.itemListings.length; ++i) {
            shuffledListings.add(i);
        }
        Collections.shuffle(shuffledListings, this.random);
        return shuffledListings;
    }

    public int getMaxOffers() {
        return this.maxOffers;
    }
}

