/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.objects.math;

import com.seibel.lod.core.util.LodUtil;

public class Vec3d {
    public static Vec3d XNeg = new Vec3d(-1.0, 0.0, 0.0);
    public static Vec3d XPos = new Vec3d(1.0, 0.0, 0.0);
    public static Vec3d YNeg = new Vec3d(0.0, -1.0, 0.0);
    public static Vec3d YPos = new Vec3d(0.0, 1.0, 0.0);
    public static Vec3d ZNeg = new Vec3d(0.0, 0.0, -1.0);
    public static Vec3d ZPos = new Vec3d(0.0, 0.0, 1.0);
    public static final Vec3d ZERO_VECTOR = new Vec3d(0.0, 0.0, 0.0);
    public double x;
    public double y;
    public double z;

    public Vec3d() {
    }

    public Vec3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            Vec3d Vec3f2 = (Vec3d)obj;
            if (Double.compare(Vec3f2.x, this.x) != 0) {
                return false;
            }
            if (Double.compare(Vec3f2.y, this.y) != 0) {
                return false;
            }
            return Double.compare(Vec3f2.z, this.z) == 0;
        }
        return false;
    }

    public int hashCode() {
        long longVal = Double.doubleToLongBits(this.x);
        int intVal = (int)(longVal ^ longVal >>> 32);
        longVal = Double.doubleToLongBits(this.y);
        intVal = 31 * intVal + (int)(longVal ^ longVal >>> 32);
        longVal = Double.doubleToLongBits(this.z);
        return 31 * intVal + (int)(longVal ^ longVal >>> 32);
    }

    public void mul(double scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
    }

    public void mul(double x, double y, double z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
    }

    public void clamp(double min, double max) {
        this.x = LodUtil.clamp(min, this.x, max);
        this.y = LodUtil.clamp(min, this.y, max);
        this.z = LodUtil.clamp(min, this.z, max);
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    public void add(Vec3d vector) {
        this.x += vector.x;
        this.y += vector.y;
        this.z += vector.z;
    }

    public void subtract(Vec3d vector) {
        this.x -= vector.x;
        this.y -= vector.y;
        this.z -= vector.z;
    }

    public double dotProduct(Vec3d vector) {
        return this.x * vector.x + this.y * vector.y + this.z * vector.z;
    }

    public Vec3d normalize() {
        double value = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        return value < 1.0E-4 ? ZERO_VECTOR : new Vec3d(this.x / value, this.y / value, this.z / value);
    }

    public void crossProduct(Vec3d vector) {
        double f = this.x;
        double f1 = this.y;
        double f2 = this.z;
        double f3 = vector.x;
        double f4 = vector.y;
        double f5 = vector.z;
        this.x = f1 * f5 - f2 * f4;
        this.y = f2 * f3 - f * f5;
        this.z = f * f4 - f1 * f3;
    }

    public Vec3d copy() {
        return new Vec3d(this.x, this.y, this.z);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public Vec3d(double[] values) {
        this.set(values);
    }

    public void set(double[] values) {
        this.x = values[0];
        this.y = values[1];
        this.z = values[2];
    }
}

