/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.objects.math;

import com.seibel.lod.core.util.LodUtil;

public class Vec3i {
    public static Vec3i XNeg = new Vec3i(-1, 0, 0);
    public static Vec3i XPos = new Vec3i(1, 0, 0);
    public static Vec3i YNeg = new Vec3i(0, -1, 0);
    public static Vec3i YPos = new Vec3i(0, 1, 0);
    public static Vec3i ZNeg = new Vec3i(0, 0, -1);
    public static Vec3i ZPos = new Vec3i(0, 0, 1);
    public int x;
    public int y;
    public int z;

    public Vec3i() {
    }

    public Vec3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            Vec3i Vec3f2 = (Vec3i)obj;
            if (Float.compare(Vec3f2.x, this.x) != 0) {
                return false;
            }
            if (Float.compare(Vec3f2.y, this.y) != 0) {
                return false;
            }
            return Float.compare(Vec3f2.z, this.z) == 0;
        }
        return false;
    }

    public int hashCode() {
        int i = Float.floatToIntBits(this.x);
        i = 31 * i + Float.floatToIntBits(this.y);
        return 31 * i + Float.floatToIntBits(this.z);
    }

    public void mul(float scalar) {
        this.x = (int)((float)this.x * scalar);
        this.y = (int)((float)this.y * scalar);
        this.z = (int)((float)this.z * scalar);
    }

    public void mul(float x, float y, float z) {
        this.x = (int)((float)this.x * x);
        this.y = (int)((float)this.y * y);
        this.z = (int)((float)this.z * z);
    }

    public void clamp(int min, int max) {
        this.x = LodUtil.clamp(min, this.x, max);
        this.y = LodUtil.clamp(min, this.y, max);
        this.z = LodUtil.clamp(min, this.z, max);
    }

    public void set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void add(int x, int y, int z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    public void add(Vec3i vector) {
        this.x += vector.x;
        this.y += vector.y;
        this.z += vector.z;
    }

    public void subtract(Vec3i vector) {
        this.x -= vector.x;
        this.y -= vector.y;
        this.z -= vector.z;
    }

    public double distSqr(double x, double y, double z, boolean centerOfBlock) {
        double offset = centerOfBlock ? 0.5 : 0.0;
        double xAdd = (double)this.x + offset - x;
        double yAdd = (double)this.y + offset - y;
        double zAdd = (double)this.z + offset - z;
        return xAdd * xAdd + yAdd * yAdd + zAdd * zAdd;
    }

    public int distManhattan(Vec3i otherVec) {
        float xSub = Math.abs(otherVec.x - this.x);
        float ySub = Math.abs(otherVec.y - this.y);
        float zSub = Math.abs(otherVec.z - this.z);
        return (int)(xSub + ySub + zSub);
    }

    public float dotProduct(Vec3i vector) {
        return this.x * vector.x + this.y * vector.y + this.z * vector.z;
    }

    public Vec3i cross(Vec3i otherVec) {
        return new Vec3i(this.y * otherVec.z - this.z * otherVec.y, this.z * otherVec.x - this.x * otherVec.z, this.x * otherVec.y - this.y * otherVec.x);
    }

    public Vec3i copy() {
        return new Vec3i(this.x, this.y, this.z);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public Vec3i(int[] values) {
        this.set(values);
    }

    public void set(int[] values) {
        this.x = values[0];
        this.y = values[1];
        this.z = values[2];
    }
}

