/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.forge.mixins;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.seibel.lod.core.api.ClientApi;
import com.seibel.lod.core.objects.math.Mat4f;
import forge.com.seibel.lod.common.Config;
import forge.com.seibel.lod.common.wrappers.McObjectConverter;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import org.lwjgl.opengl.GL15;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldRenderer.class})
public class MixinWorldRenderer {
    private static float previousPartialTicks = 0.0f;

    public MixinWorldRenderer() {
        throw new NullPointerException("Null cannot be cast to non-null type.");
    }

    @Inject(at={@At(value="RETURN")}, method={"renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"})
    private void renderSky(MatrixStack matrixStackIn, float partialTicks, CallbackInfo callback) {
        previousPartialTicks = partialTicks;
    }

    @Inject(at={@At(value="HEAD")}, method={"renderChunkLayer(Lnet/minecraft/client/renderer/RenderType;Lcom/mojang/blaze3d/vertex/PoseStack;DDD)V"}, cancellable=true)
    private void renderChunkLayer(RenderType renderType, MatrixStack matrixStackIn, double xIn, double yIn, double zIn, CallbackInfo callback) {
        if (renderType.equals((Object)RenderType.func_228639_c_())) {
            float[] mcProjMatrixRaw = new float[16];
            GL15.glGetFloatv((int)2983, (float[])mcProjMatrixRaw);
            Mat4f mcProjectionMatrix = new Mat4f(mcProjMatrixRaw);
            mcProjectionMatrix.transpose();
            Mat4f mcModelViewMatrix = McObjectConverter.Convert(matrixStackIn.func_227866_c_().func_227870_a_());
            ClientApi.INSTANCE.renderLods(mcModelViewMatrix, mcProjectionMatrix, previousPartialTicks);
        }
        if (Config.Client.Advanced.lodOnlyMode) {
            callback.cancel();
        }
    }
}

