/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.seibel.lod.common.wrappers.minecraft;

import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.handlers.dependencyInjection.ModAccessorHandler;
import com.seibel.lod.core.objects.math.Mat4f;
import com.seibel.lod.core.objects.math.Vec3d;
import com.seibel.lod.core.objects.math.Vec3f;
import com.seibel.lod.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.lod.core.wrapperInterfaces.block.AbstractBlockPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.chunk.AbstractChunkPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.lod.core.wrapperInterfaces.misc.ILightMapWrapper;
import com.seibel.lod.core.wrapperInterfaces.modAccessor.IOptifineAccessor;
import com.seibel.lod.core.wrapperInterfaces.modAccessor.ISodiumAccessor;
import fabric.com.seibel.lod.common.wrappers.McObjectConverter;
import fabric.com.seibel.lod.common.wrappers.WrapperFactory;
import fabric.com.seibel.lod.common.wrappers.block.BlockPosWrapper;
import fabric.com.seibel.lod.common.wrappers.minecraft.MinecraftClientWrapper;
import fabric.com.seibel.lod.common.wrappers.misc.LightMapWrapper;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.awt.Color;
import java.util.HashSet;
import java.util.stream.Collectors;
import net.minecraft.class_1011;
import net.minecraft.class_1160;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3610;
import net.minecraft.class_4184;
import net.minecraft.class_757;
import net.minecraft.class_761;
import org.lwjgl.opengl.GL15;

public class MinecraftRenderWrapper
implements IMinecraftRenderWrapper {
    public static final MinecraftRenderWrapper INSTANCE = new MinecraftRenderWrapper();
    private static final class_310 MC = class_310.method_1551();
    private static final class_757 GAME_RENDERER = MinecraftRenderWrapper.MC.field_1773;
    private static final IWrapperFactory FACTORY = WrapperFactory.INSTANCE;
    public LightMapWrapper lightmap = null;
    public boolean usingBackupGetVanillaRenderedChunks = false;

    @Override
    public Vec3f getLookAtVector() {
        class_4184 camera = GAME_RENDERER.method_19418();
        class_1160 cameraDir = camera.method_19335();
        return new Vec3f(cameraDir.method_4943(), cameraDir.method_4945(), cameraDir.method_4947());
    }

    @Override
    public AbstractBlockPosWrapper getCameraBlockPosition() {
        class_4184 camera = GAME_RENDERER.method_19418();
        class_2338 blockPos = camera.method_19328();
        return new BlockPosWrapper(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
    }

    @Override
    public boolean playerHasBlindnessEffect() {
        return MinecraftRenderWrapper.MC.field_1724.method_6088().get(class_1294.field_5919) != null;
    }

    @Override
    public Vec3d getCameraExactPosition() {
        class_4184 camera = GAME_RENDERER.method_19418();
        class_243 projectedView = camera.method_19326();
        return new Vec3d(projectedView.field_1352, projectedView.field_1351, projectedView.field_1350);
    }

    @Override
    public Mat4f getDefaultProjectionMatrix(float partialTicks) {
        return McObjectConverter.Convert(GAME_RENDERER.method_22973(GAME_RENDERER.method_19418(), partialTicks, true));
    }

    @Override
    public double getGamma() {
        return MinecraftRenderWrapper.MC.field_1690.field_1840;
    }

    @Override
    public Color getFogColor(float partialTicks) {
        float[] colorValues = new float[4];
        GL15.glGetFloatv((int)2918, (float[])colorValues);
        return new Color(colorValues[0], colorValues[1], colorValues[2], colorValues[3]);
    }

    @Override
    public Color getSkyColor() {
        if (MinecraftRenderWrapper.MC.field_1687.method_8597().method_12491()) {
            class_243 colorValues = MinecraftRenderWrapper.MC.field_1687.method_23777(MinecraftRenderWrapper.MC.field_1773.method_19418().method_19328(), MC.method_1488());
            return new Color((float)colorValues.field_1352, (float)colorValues.field_1351, (float)colorValues.field_1350);
        }
        return new Color(0, 0, 0);
    }

    @Override
    public double getFov(float partialTicks) {
        return GAME_RENDERER.method_3196(GAME_RENDERER.method_19418(), partialTicks, true);
    }

    @Override
    public int getRenderDistance() {
        return MinecraftRenderWrapper.MC.field_1690.field_1870;
    }

    @Override
    public int getScreenWidth() {
        return MC.method_22683().method_4489();
    }

    @Override
    public int getScreenHeight() {
        return MC.method_22683().method_4506();
    }

    private class_276 getRenderTarget() {
        class_276 r = null;
        return r != null ? r : MC.method_1522();
    }

    @Override
    public int getTargetFrameBuffer() {
        return this.getRenderTarget().field_1476;
    }

    @Override
    public int getTargetFrameBufferViewportWidth() {
        return this.getRenderTarget().field_1480;
    }

    @Override
    public int getTargetFrameBufferViewportHeight() {
        return this.getRenderTarget().field_1477;
    }

    @Override
    public HashSet<AbstractChunkPosWrapper> getVanillaRenderedChunks() {
        ISodiumAccessor sodium = ModAccessorHandler.get(ISodiumAccessor.class);
        if (sodium != null) {
            return sodium.getNormalRenderedChunks();
        }
        IOptifineAccessor optifine = ModAccessorHandler.get(IOptifineAccessor.class);
        if (optifine != null) {
            HashSet<AbstractChunkPosWrapper> pos = optifine.getNormalRenderedChunks();
            if (pos == null) {
                pos = this.getMaximumRenderedChunks();
            }
            return pos;
        }
        if (!this.usingBackupGetVanillaRenderedChunks) {
            try {
                class_761 levelRenderer = MinecraftRenderWrapper.MC.field_1769;
                ObjectList chunks = levelRenderer.field_4086;
                return chunks.stream().map(chunk -> {
                    class_238 chunkBoundingBox = chunk.field_4124.field_4458;
                    return FACTORY.createChunkPos(Math.floorDiv((int)chunkBoundingBox.field_1323, 16), Math.floorDiv((int)chunkBoundingBox.field_1321, 16));
                }).collect(Collectors.toCollection(HashSet::new));
            }
            catch (LinkageError e) {
                try {
                    MinecraftClientWrapper.INSTANCE.sendChatMessage("\u00a7e\u00a7l\u00a7uWARNING: Distant Horizons: getVanillaRenderedChunks method failed. Using Backup Method.");
                    MinecraftClientWrapper.INSTANCE.sendChatMessage("\u00a7eOverdraw prevention will be worse than normal.");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ApiShared.LOGGER.error("getVanillaRenderedChunks Error: ", (Throwable)e);
                this.usingBackupGetVanillaRenderedChunks = true;
            }
        }
        return this.getMaximumRenderedChunks();
    }

    @Override
    public ILightMapWrapper getLightmapWrapper() {
        return this.lightmap;
    }

    @Override
    public boolean isFogStateSpecial() {
        class_4184 camera = GAME_RENDERER.method_19418();
        class_3610 fluidState = camera.method_19334();
        class_1297 entity = camera.method_19331();
        boolean isUnderWater = entity instanceof class_1309 && ((class_1309)entity).method_6059(class_1294.field_5919);
        isUnderWater |= fluidState.method_15767((class_3494)class_3486.field_15517);
        return isUnderWater |= fluidState.method_15767((class_3494)class_3486.field_15518);
    }

    @Override
    public boolean tryDisableVanillaFog() {
        return true;
    }

    public void updateLightmap(class_1011 lightPixels) {
        if (this.lightmap == null) {
            this.lightmap = new LightMapWrapper();
        }
        this.lightmap.uploadLightmap(lightPixels);
    }
}

