/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers;

import com.seibel.lod.core.enums.LodDirection;
import com.seibel.lod.core.objects.math.Mat4f;
import com.seibel.lod.core.wrapperInterfaces.block.AbstractBlockPosWrapper;
import java.nio.FloatBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;

public class McObjectConverter {
    static final Direction[] directions;
    static final LodDirection[] lodDirections;

    public static Mat4f Convert(Matrix4f mcMatrix) {
        FloatBuffer buffer = FloatBuffer.allocate(16);
        mcMatrix.func_195879_b(buffer);
        Mat4f matrix = new Mat4f(buffer);
        matrix.transpose();
        return matrix;
    }

    public static BlockPos Convert(AbstractBlockPosWrapper wrappedPos) {
        return new BlockPos(wrappedPos.getX(), wrappedPos.getY(), wrappedPos.getZ());
    }

    public static Direction Convert(LodDirection lodDirection) {
        return directions[lodDirection.ordinal()];
    }

    public static LodDirection Convert(Direction direction) {
        return lodDirections[direction.ordinal()];
    }

    static {
        LodDirection[] lodDirs = LodDirection.values();
        directions = new Direction[lodDirs.length];
        lodDirections = new LodDirection[lodDirs.length];
        for (LodDirection lodDir : lodDirs) {
            Direction dir = Enum.valueOf(Direction.class, lodDir.name());
            if (dir == null) {
                throw new IllegalArgumentException("Invalid direction on init mapping: " + (Object)((Object)lodDir));
            }
            McObjectConverter.directions[lodDir.ordinal()] = dir;
            McObjectConverter.lodDirections[dir.ordinal()] = lodDir;
        }
    }
}

