/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.block;

import com.seibel.lod.core.enums.LodDirection;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.util.ColorUtil;
import com.seibel.lod.core.wrapperInterfaces.block.AbstractBlockPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.block.IBlockDetailWrapper;
import com.seibel.lod.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import forge.com.seibel.lod.common.wrappers.McObjectConverter;
import forge.com.seibel.lod.common.wrappers.block.TextureAtlasSpriteWrapper;
import forge.com.seibel.lod.common.wrappers.block.TintGetterOverrideFast;
import forge.com.seibel.lod.common.wrappers.block.TintGetterOverrideSmooth;
import forge.com.seibel.lod.common.wrappers.chunk.ChunkWrapper;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class BlockDetailWrapper
extends IBlockDetailWrapper {
    private static final ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    public static final int FLOWER_COLOR_SCALE = 5;
    public static final Random random = new Random(0L);
    private static final Block[] BLOCK_TO_AVOID = new Block[]{Blocks.field_150350_a, Blocks.field_201941_jj, Blocks.field_180401_cv};
    private static final Direction[] DIRECTION_ORDER = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.DOWN};
    final BlockState state;
    boolean[] dontOccludeFaces = null;
    boolean noCollision = false;
    boolean noFullFace = false;
    boolean isColorResolved = false;
    int baseColor = 0;
    boolean needShade = true;
    boolean needPostTinting = false;
    int tintIndex = 0;
    public static BlockDetailWrapper NULL_BLOCK_DETAIL = new BlockDetailWrapper();

    private static int calculateColorFromTexture(TextureAtlasSprite texture, ColorMode colorMode) {
        int tempColor;
        int count = 0;
        double alpha = 0.0;
        double red = 0.0;
        double green = 0.0;
        double blue = 0.0;
        for (int u = 0; u < texture.func_94211_a(); ++u) {
            for (int v = 0; v < texture.func_94216_b(); ++v) {
                tempColor = TextureAtlasSpriteWrapper.getPixelRGBA(texture, 0, u, v);
                double r = (double)(tempColor & 0xFF) / 255.0;
                double g = (double)((tempColor & 0xFF00) >>> 8) / 255.0;
                double b = (double)((tempColor & 0xFF0000) >>> 16) / 255.0;
                double a = (double)((tempColor & 0xFF000000) >>> 24) / 255.0;
                int scale = 1;
                if (colorMode == ColorMode.Leaves) {
                    r *= a;
                    g *= a;
                    b *= a;
                    a = 1.0;
                } else {
                    if (a == 0.0) continue;
                    if (colorMode == ColorMode.Flower && (g + 0.1 < b || g + 0.1 < r)) {
                        scale = 5;
                    }
                }
                count += scale;
                alpha += a * a * (double)scale;
                red += r * r * (double)scale;
                green += g * g * (double)scale;
                blue += b * b * (double)scale;
            }
        }
        tempColor = count == 0 ? ColorUtil.rgbToInt(255, 255, 0, 255) : ColorUtil.rgbToInt((int)(Math.sqrt(alpha / (double)count) * 255.0), (int)(Math.sqrt(red / (double)count) * 255.0), (int)(Math.sqrt(green / (double)count) * 255.0), (int)(Math.sqrt(blue / (double)count) * 255.0));
        double colorAlpha = (double)ColorUtil.getAlpha(tempColor) / 255.0;
        tempColor = ColorUtil.rgbToInt(ColorUtil.getAlpha(tempColor), (int)((double)ColorUtil.getRed(tempColor) * colorAlpha), (int)((double)ColorUtil.getGreen(tempColor) * colorAlpha), (int)((double)ColorUtil.getBlue(tempColor) * colorAlpha));
        return tempColor;
    }

    private static boolean isBlockToBeAvoid(Block b) {
        for (Block bta : BLOCK_TO_AVOID) {
            if (bta != b) continue;
            return true;
        }
        return false;
    }

    public BlockDetailWrapper(BlockState state, BlockPos pos, IWorldReader getter) {
        this.state = state;
        this.resolveShapes(getter, pos);
    }

    private BlockDetailWrapper() {
        this.state = null;
    }

    static BlockDetailWrapper make(BlockState bs, BlockPos pos, IWorldReader getter) {
        if (!bs.func_204520_s().func_206888_e()) {
            if (BlockDetailWrapper.isBlockToBeAvoid(bs.func_177230_c())) {
                return NULL_BLOCK_DETAIL;
            }
            if (bs.func_196958_f()) {
                return NULL_BLOCK_DETAIL;
            }
            return new BlockDetailWrapper(bs, pos, getter);
        }
        if (bs.func_185901_i() != BlockRenderType.MODEL) {
            return NULL_BLOCK_DETAIL;
        }
        if (BlockDetailWrapper.isBlockToBeAvoid(bs.func_177230_c())) {
            return NULL_BLOCK_DETAIL;
        }
        return new BlockDetailWrapper(bs, pos, getter);
    }

    private void resolveShapes(IWorldReader sampleGetter, BlockPos samplePos) {
        if (this.state.func_204520_s().func_206888_e()) {
            this.noCollision = this.state.func_196952_d((IBlockReader)sampleGetter, samplePos).func_197766_b();
            this.dontOccludeFaces = new boolean[6];
            if (!this.state.func_200132_m()) {
                Arrays.fill(this.dontOccludeFaces, true);
            }
            VoxelShape voxelShape = this.state.func_196954_c((IBlockReader)sampleGetter, samplePos);
            if (voxelShape.func_197766_b()) {
                this.noFullFace = true;
            } else {
                AxisAlignedBB bbox = voxelShape.func_197752_a();
                double xWidth = bbox.field_72336_d - bbox.field_72340_a;
                double yWidth = bbox.field_72337_e - bbox.field_72338_b;
                double zWidth = bbox.field_72334_f - bbox.field_72339_c;
                this.noFullFace = xWidth < 1.0 && zWidth < 1.0 && yWidth < 1.0;
            }
        } else {
            this.dontOccludeFaces = new boolean[6];
        }
    }

    private void resolveColors() {
        if (this.isColorResolved) {
            return;
        }
        if (this.state.func_204520_s().func_206888_e()) {
            List quads = null;
            for (Direction direction : DIRECTION_ORDER) {
                quads = Minecraft.func_71410_x().func_209506_al().func_174954_c().func_178125_b(this.state).func_200117_a(this.state, direction, random);
                if (!quads.isEmpty() && (!(this.state.func_177230_c() instanceof RotatedPillarBlock) || direction != Direction.UP)) break;
            }
            if (quads == null || quads.isEmpty()) {
                quads = Minecraft.func_71410_x().func_209506_al().func_174954_c().func_178125_b(this.state).func_200117_a(this.state, null, random);
            }
            if (quads != null && !quads.isEmpty()) {
                this.needPostTinting = ((BakedQuad)quads.get(0)).func_178212_b();
                this.needShade = ((BakedQuad)quads.get(0)).func_239287_f_();
                this.tintIndex = ((BakedQuad)quads.get(0)).func_178211_c();
                this.baseColor = BlockDetailWrapper.calculateColorFromTexture(((BakedQuad)quads.get((int)0)).field_187509_d, ColorMode.getColorMode(this.state.func_177230_c()));
            } else {
                this.needPostTinting = false;
                this.needShade = false;
                this.tintIndex = 0;
                this.baseColor = BlockDetailWrapper.calculateColorFromTexture(Minecraft.func_71410_x().func_209506_al().func_174954_c().func_178122_a(this.state), ColorMode.getColorMode(this.state.func_177230_c()));
            }
        } else {
            this.needPostTinting = true;
            this.needShade = false;
            this.tintIndex = 0;
            this.baseColor = BlockDetailWrapper.calculateColorFromTexture(Minecraft.func_71410_x().func_209506_al().func_174954_c().func_178122_a(this.state), ColorMode.getColorMode(this.state.func_177230_c()));
        }
        this.isColorResolved = true;
    }

    private IBlockDisplayReader wrapColorResolver(IWorldReader level) {
        int blendDistance = CONFIG.client().graphics().quality().getLodBiomeBlending();
        if (blendDistance == 0) {
            return new TintGetterOverrideFast(level);
        }
        return new TintGetterOverrideSmooth(level, blendDistance);
    }

    @Override
    public int getAndResolveFaceColor(LodDirection dir, IChunkWrapper chunk, AbstractBlockPosWrapper blockPos) {
        this.resolveColors();
        if (!this.needPostTinting) {
            return this.baseColor;
        }
        int tintColor = Minecraft.func_71410_x().func_184125_al().func_228054_a_(this.state, this.wrapColorResolver(((ChunkWrapper)chunk).getColorResolver()), McObjectConverter.Convert(blockPos), this.tintIndex);
        if (tintColor == -1) {
            return this.baseColor;
        }
        return ColorUtil.multiplyARGBwithRGB(this.baseColor, tintColor);
    }

    @Override
    public boolean hasFaceCullingFor(LodDirection dir) {
        return !this.dontOccludeFaces[dir.ordinal()];
    }

    @Override
    public boolean hasNoCollision() {
        return this.noCollision;
    }

    @Override
    public boolean noFaceIsFullFace() {
        return this.noFullFace;
    }

    @Override
    public String serialize() {
        return null;
    }

    @Override
    protected boolean isSame(IBlockDetailWrapper iBlockDetail) {
        return ((BlockDetailWrapper)iBlockDetail).state.func_177230_c().equals(this.state.func_177230_c());
    }

    @Override
    public String toString() {
        return "BlockDetail{" + this.state + "}";
    }

    static enum ColorMode {
        Default,
        Flower,
        Leaves;


        static ColorMode getColorMode(Block b) {
            if (b instanceof LeavesBlock) {
                return Leaves;
            }
            if (b instanceof FlowerBlock) {
                return Flower;
            }
            return Default;
        }
    }
}

