/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.worldGeneration.mimicObject;

import com.seibel.lod.core.logging.ConfigBasedLogger;
import forge.com.seibel.lod.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import java.util.Objects;
import java.util.Set;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IObjectIntIterable;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.palette.UpgradeData;
import net.minecraft.util.registry.DefaultedRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.ITickList;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.SerializableTickList;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimerTickList;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.lighting.WorldLightManager;

public class ChunkLoader {
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG_18 = "block_ticks";
    private static final String FLUID_TICKS_TAG_18 = "fluid_ticks";
    private static final String BLOCK_TICKS_TAG_PRE18 = "TileTicks";
    private static final String FLUID_TICKS_TAG_PRE18 = "LiquidTicks";
    private static final ConfigBasedLogger LOGGER = BatchGenerationEnvironment.LOAD_LOGGER;

    private static ChunkSection[] readSections(IWorld level, WorldLightManager lightEngine, ChunkPos chunkPos, CompoundNBT chunkData) {
        int i = 16;
        ChunkSection[] chunkSections = new ChunkSection[i];
        boolean isLightOn = chunkData.func_74767_n("isLightOn");
        boolean hasSkyLight = level.func_230315_m_().func_218272_d();
        ListNBT tagSections = chunkData.func_150295_c("Sections", 10);
        if (tagSections.isEmpty()) {
            tagSections = chunkData.func_150295_c("sections", 10);
        }
        for (int j = 0; j < tagSections.size(); ++j) {
            CompoundNBT tagSection = tagSections.func_150305_b(j);
            byte sectionYPos = tagSection.func_74771_c("Y");
            if (tagSection.func_150297_b("Palette", 9) && tagSection.func_150297_b("BlockStates", 12)) {
                ChunkSection levelChunkSection = new ChunkSection(sectionYPos << 4);
                levelChunkSection.func_186049_g().func_222642_a(tagSection.func_150295_c("Palette", 10), tagSection.func_197645_o("BlockStates"));
                levelChunkSection.func_76672_e();
                if (!levelChunkSection.func_76663_a()) {
                    chunkSections[sectionYPos] = levelChunkSection;
                }
            }
            if (!isLightOn) continue;
            if (tagSection.func_150297_b("BlockLight", 7)) {
                lightEngine.func_215574_a(LightType.BLOCK, SectionPos.func_218156_a((ChunkPos)chunkPos, (int)sectionYPos), new NibbleArray(tagSection.func_74770_j("BlockLight")), true);
            }
            if (!hasSkyLight || !tagSection.func_150297_b("SkyLight", 7)) continue;
            lightEngine.func_215574_a(LightType.SKY, SectionPos.func_218156_a((ChunkPos)chunkPos, (int)sectionYPos), new NibbleArray(tagSection.func_74770_j("SkyLight")), true);
        }
        return chunkSections;
    }

    private static void readHeightmaps(Chunk chunk, CompoundNBT chunkData) {
        CompoundNBT tagHeightmaps = chunkData.func_74775_l("Heightmaps");
        for (Heightmap.Type type : ChunkStatus.field_222617_m.func_222595_h()) {
            String heightmap = type.func_203500_b();
            if (!tagHeightmaps.func_150297_b(heightmap, 12)) continue;
            chunk.func_201607_a(type, tagHeightmaps.func_197645_o(heightmap));
        }
        Heightmap.func_222690_a((IChunk)chunk, (Set)ChunkStatus.field_222617_m.func_222595_h());
    }

    private static void readPostPocessings(Chunk chunk, CompoundNBT chunkData) {
        ListNBT tagPostProcessings = chunkData.func_150295_c("PostProcessing", 9);
        for (int n = 0; n < tagPostProcessings.size(); ++n) {
            ListNBT listTag3 = tagPostProcessings.func_202169_e(n);
            for (int o = 0; o < listTag3.size(); ++o) {
                chunk.func_201636_b(listTag3.func_202170_f(o), n);
            }
        }
    }

    public static ChunkStatus.Type readChunkType(CompoundNBT tagLevel) {
        ChunkStatus chunkStatus = ChunkStatus.func_222591_a((String)tagLevel.func_74779_i("Status"));
        if (chunkStatus != null) {
            return chunkStatus.func_202129_d();
        }
        return ChunkStatus.Type.PROTOCHUNK;
    }

    public static Chunk read(ISeedReader level, WorldLightManager lightEngine, ChunkPos chunkPos, CompoundNBT chunkData) {
        ChunkPrimerTickList blockTicks;
        CompoundNBT tagLevel = chunkData.func_74775_l("Level");
        ChunkPos actualPos = new ChunkPos(tagLevel.func_74762_e("xPos"), tagLevel.func_74762_e("zPos"));
        if (!Objects.equals(chunkPos, actualPos)) {
            LOGGER.error("Chunk file at {} is in the wrong location; Ignoring. (Expected {}, got {})", chunkPos, chunkPos, actualPos);
            return null;
        }
        ChunkStatus.Type chunkType = ChunkLoader.readChunkType(tagLevel);
        if (chunkType != ChunkStatus.Type.LEVELCHUNK) {
            return null;
        }
        long inhabitedTime = tagLevel.func_74763_f("InhabitedTime");
        UpgradeData upgradeData = tagLevel.func_150297_b(TAG_UPGRADE_DATA, 10) ? new UpgradeData(tagLevel.func_74775_l(TAG_UPGRADE_DATA)) : UpgradeData.field_196994_a;
        boolean isLightOn = tagLevel.func_74767_n("isLightOn");
        if (isLightOn) {
            lightEngine.func_223115_b(chunkPos, true);
        }
        BiomeContainer chunkBiomeContainer = new BiomeContainer((IObjectIntIterable)level.func_201672_e().func_241828_r().func_243612_b(Registry.field_239720_u_), chunkPos, level.func_201672_e().func_72863_F().func_201711_g().func_202090_b(), tagLevel.func_150297_b("Biomes", 11) ? tagLevel.func_74759_k("Biomes") : null);
        Object object = tagLevel.func_150297_b(BLOCK_TICKS_TAG_PRE18, 9) ? SerializableTickList.func_222984_a((ListNBT)tagLevel.func_150295_c(BLOCK_TICKS_TAG_PRE18, 10), arg_0 -> ((DefaultedRegistry)Registry.field_212618_g).func_177774_c(arg_0), arg_0 -> ((DefaultedRegistry)Registry.field_212618_g).func_82594_a(arg_0)) : (blockTicks = new ChunkPrimerTickList(block -> block == null || block.func_176223_P().func_196958_f(), chunkPos, tagLevel.func_150295_c("ToBeTicked", 9)));
        ChunkPrimerTickList fluidTicks = tagLevel.func_150297_b(FLUID_TICKS_TAG_PRE18, 9) ? SerializableTickList.func_222984_a((ListNBT)tagLevel.func_150295_c(FLUID_TICKS_TAG_PRE18, 10), arg_0 -> ((DefaultedRegistry)Registry.field_212619_h).func_177774_c(arg_0), arg_0 -> ((DefaultedRegistry)Registry.field_212619_h).func_82594_a(arg_0)) : new ChunkPrimerTickList(fluid -> fluid == null || fluid == Fluids.field_204541_a, chunkPos, tagLevel.func_150295_c("LiquidsToBeTicked", 9));
        ChunkSection[] levelChunkSections = ChunkLoader.readSections((IWorld)level, lightEngine, chunkPos, tagLevel);
        Chunk chunk = new Chunk((World)level.func_201672_e(), chunkPos, chunkBiomeContainer, upgradeData, (ITickList)blockTicks, (ITickList)fluidTicks, inhabitedTime, levelChunkSections, null);
        chunk.func_217305_b(isLightOn);
        ChunkLoader.readHeightmaps(chunk, chunkData);
        ChunkLoader.readPostPocessings(chunk, chunkData);
        return chunk;
    }

    private static void logErrors(ChunkPos chunkPos, int i, String string) {
        LOGGER.error("Distant Horizons: Recoverable errors when loading section [" + chunkPos.field_77276_a + ", " + i + ", " + chunkPos.field_77275_b + "]: " + string, new Object[0]);
    }
}

