/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.worldGeneration.mimicObject;

import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.enums.config.LightGenerationMode;
import forge.com.seibel.lod.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import forge.com.seibel.lod.common.wrappers.worldGeneration.mimicObject.WorldGenLevelLightEngine;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimerWrapper;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;

public class LightedWorldGenRegion
extends WorldGenRegion {
    public final WorldGenLevelLightEngine light;
    public final LightGenerationMode lightMode;
    public final BatchGenerationEnvironment.EmptyChunkGenerator generator;
    public final int writeRadius;
    public final int size;
    private final ChunkPos firstPos;
    private final List<IChunk> cache;
    Long2ObjectOpenHashMap<IChunk> chunkMap = new Long2ObjectOpenHashMap();
    private ChunkPos overrideCenterPos = null;
    private static ChunkStatus debugTriggeredForStatus = null;

    public void setOverrideCenter(ChunkPos pos) {
        this.overrideCenterPos = pos;
    }

    public int func_201679_a() {
        return this.overrideCenterPos == null ? super.func_201679_a() : this.overrideCenterPos.field_77276_a;
    }

    public int func_201680_b() {
        return this.overrideCenterPos == null ? super.func_201679_a() : this.overrideCenterPos.field_77275_b;
    }

    public LightedWorldGenRegion(ServerWorld serverLevel, WorldGenLevelLightEngine lightEngine, List<IChunk> list, ChunkStatus chunkStatus, int i, LightGenerationMode lightMode, BatchGenerationEnvironment.EmptyChunkGenerator generator) {
        super(serverLevel, list);
        this.lightMode = lightMode;
        this.firstPos = list.get(0).func_76632_l();
        this.generator = generator;
        this.light = lightEngine;
        this.writeRadius = i;
        this.cache = list;
        this.size = MathHelper.func_76128_c((double)Math.sqrt(list.size()));
    }

    public boolean func_241211_a_(BlockPos blockPos, BlockState blockState, int i, int j) {
        IChunk chunkAccess = this.func_217349_x(blockPos);
        if (chunkAccess instanceof Chunk) {
            return true;
        }
        chunkAccess.func_177436_a(blockPos, blockState, false);
        return true;
    }

    public boolean func_241212_a_(BlockPos blockPos, boolean bl, @Nullable Entity entity, int i) {
        BlockState blockState = this.func_180495_p(blockPos);
        if (blockState.func_196958_f()) {
            return false;
        }
        return this.func_241211_a_(blockPos, Blocks.field_150350_a.func_176223_P(), 3, i);
    }

    public TileEntity func_175625_s(BlockPos blockPos) {
        return null;
    }

    public boolean func_217376_c(Entity entity) {
        return true;
    }

    public IChunk func_212866_a_(int i, int j) {
        return this.func_217348_a(i, j, ChunkStatus.field_223226_a_);
    }

    public IChunk func_217348_a(int i, int j, ChunkStatus chunkStatus) {
        return this.func_217353_a(i, j, chunkStatus, true);
    }

    private IChunk superGetChunk(int x, int z, ChunkStatus cs) {
        int k = x - this.firstPos.field_77276_a;
        int l = z - this.firstPos.field_77275_b;
        return this.cache.get(k + l * this.size);
    }

    private boolean superHasChunk(int x, int z) {
        int k = x - this.firstPos.field_77276_a;
        int l = z - this.firstPos.field_77275_b;
        return l >= 0 && l < this.size && k >= 0 && k < this.size;
    }

    @Nullable
    public IChunk func_217353_a(int i, int j, ChunkStatus chunkStatus, boolean bl) {
        IChunk chunk = this.getChunkAccess(i, j, chunkStatus, bl);
        if (chunk instanceof Chunk) {
            chunk = new ChunkPrimerWrapper((Chunk)chunk);
        }
        return chunk;
    }

    private IChunk getChunkAccess(int i, int j, ChunkStatus chunkStatus, boolean bl) {
        IChunk chunk;
        IChunk iChunk = chunk = this.superHasChunk(i, j) ? this.superGetChunk(i, j, ChunkStatus.field_223226_a_) : null;
        if (chunk != null && chunk.func_201589_g().func_209003_a(chunkStatus)) {
            return chunk;
        }
        if (!bl) {
            return null;
        }
        if (chunk == null && (chunk = (IChunk)this.chunkMap.get(ChunkPos.func_77272_a((int)i, (int)j))) == null) {
            chunk = this.generator.generate(i, j);
            if (chunk == null) {
                throw new NullPointerException("The provided generator should not return null!");
            }
            this.chunkMap.put(ChunkPos.func_77272_a((int)i, (int)j), (Object)chunk);
        }
        if (chunkStatus != ChunkStatus.field_223226_a_ && chunkStatus != debugTriggeredForStatus) {
            ApiShared.LOGGER.info("WorldGen requiring " + chunkStatus + " outside expected range detected. Force passing EMPTY chunk and seeing if it works.");
            debugTriggeredForStatus = chunkStatus;
        }
        return chunk;
    }

    public WorldLightManager func_225524_e_() {
        return this.light;
    }

    public int func_226658_a_(LightType lightLayer, BlockPos blockPos) {
        if (this.lightMode != LightGenerationMode.FAST) {
            return this.light.func_215569_a(lightLayer).func_215611_b(blockPos);
        }
        if (lightLayer == LightType.BLOCK) {
            return 0;
        }
        BlockPos p = super.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, blockPos);
        return p.func_177956_o() <= blockPos.func_177956_o() ? this.func_201572_C() : 0;
    }

    public int func_226659_b_(BlockPos blockPos, int i) {
        if (this.lightMode != LightGenerationMode.FAST) {
            return this.light.func_227470_b_(blockPos, i);
        }
        BlockPos p = super.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, blockPos);
        return p.func_177956_o() <= blockPos.func_177956_o() ? this.func_201572_C() : 0;
    }

    public boolean func_226660_f_(BlockPos blockPos) {
        return this.func_226658_a_(LightType.SKY, blockPos) >= this.func_201572_C();
    }

    public int func_225525_a_(BlockPos blockPos, ColorResolver colorResolver) {
        return this.calculateBlockTint(blockPos, colorResolver);
    }

    private Biome _getBiome(BlockPos pos) {
        return this.func_226691_t_(pos);
    }

    public int calculateBlockTint(BlockPos blockPos, ColorResolver colorResolver) {
        int i = Minecraft.func_71410_x().field_71474_y.field_205217_U;
        if (i == 0) {
            return colorResolver.getColor(this._getBiome(blockPos), (double)blockPos.func_177958_n(), (double)blockPos.func_177952_p());
        }
        int j = (i * 2 + 1) * (i * 2 + 1);
        int k = 0;
        int l = 0;
        int m = 0;
        CubeCoordinateIterator cursor3D = new CubeCoordinateIterator(blockPos.func_177958_n() - i, blockPos.func_177956_o(), blockPos.func_177952_p() - i, blockPos.func_177958_n() + i, blockPos.func_177956_o(), blockPos.func_177952_p() + i);
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable();
        while (cursor3D.func_218301_a()) {
            mutableBlockPos.func_181079_c(cursor3D.func_218304_b(), cursor3D.func_218302_c(), cursor3D.func_218303_d());
            int n = colorResolver.getColor(this._getBiome((BlockPos)mutableBlockPos), (double)mutableBlockPos.func_177958_n(), (double)mutableBlockPos.func_177952_p());
            k += (n & 0xFF0000) >> 16;
            l += (n & 0xFF00) >> 8;
            m += n & 0xFF;
        }
        return (k / j & 0xFF) << 16 | (l / j & 0xFF) << 8 | m / j & 0xFF;
    }
}

