/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public class FluidDummyModel
implements IBakedModel {
    private final Fluid fluid;
    private final TextureAtlasSprite particles;
    private final Map<Direction, List<BakedQuad>> quads = new HashMap<Direction, List<BakedQuad>>();

    FluidDummyModel(Fluid fluid) {
        this.fluid = fluid;
        Function spriteGetter = Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b);
        this.particles = (TextureAtlasSprite)spriteGetter.apply(fluid.getAttributes().getStillTexture());
        this.buildQuads(spriteGetter);
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return this.quads.get(side);
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particles;
    }

    public ItemOverrideList func_188617_f() {
        return null;
    }

    private void buildQuads(Function<ResourceLocation, TextureAtlasSprite> spriteGetter) {
        TextureAtlasSprite stillSprite = spriteGetter.apply(this.fluid.getAttributes().getStillTexture());
        TextureAtlasSprite flowingSprite = spriteGetter.apply(this.fluid.getAttributes().getFlowingTexture());
        for (Direction dir : Direction.values()) {
            BakedQuadBuilder builder = new BakedQuadBuilder();
            builder.setQuadOrientation(dir);
            builder.setQuadTint(1);
            TextureAtlasSprite sprite = dir.func_176740_k() == Direction.Axis.Y ? stillSprite : flowingSprite;
            builder.setTexture(sprite);
            boolean isX = dir.func_176740_k() == Direction.Axis.X;
            boolean isY = dir.func_176740_k() == Direction.Axis.Y;
            boolean isZ = dir.func_176740_k() == Direction.Axis.Z;
            boolean isPos = dir.func_176743_c() == Direction.AxisDirection.POSITIVE;
            for (int vert = 0; vert < 4; ++vert) {
                float z;
                float y;
                float x;
                float v;
                float u = vert >= 2 ? 1.0f : 0.0f;
                float f = v = vert == 0 || vert == 3 ? 0.0f : 1.0f;
                if (isY) {
                    x = vert == 0 || vert == 3 ? 1.0f : 0.0f;
                    y = isPos ? 1.0f : 0.0f;
                    z = vert >= 2 == isPos ? 1.0f : 0.0f;
                    u = vert == 0 || vert == 3 ? 0.0f : 1.0f;
                    v = vert >= 2 ? 1.0f : 0.0f;
                } else if (isX) {
                    x = isPos ? 1.0f : 0.0f;
                    y = vert == 0 || vert == 3 ? 1.0f : 0.0f;
                    z = vert < 2 == isPos ? 1.0f : 0.0f;
                } else if (isZ) {
                    x = vert >= 2 == isPos ? 1.0f : 0.0f;
                    y = vert == 0 || vert == 3 ? 1.0f : 0.0f;
                    z = isPos ? 1.0f : 0.0f;
                } else {
                    throw new IllegalArgumentException("Invalid dir!");
                }
                this.putVertexData((IVertexConsumer)builder, new Vector4f(x, y, z, 1.0f), new Vector2f(u, v), dir.func_229386_k_(), new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), new Vector2f(240.0f, 240.0f), sprite);
            }
            this.quads.put(dir, Collections.singletonList(builder.build()));
        }
        this.quads.put(null, Collections.emptyList());
    }

    private void putVertexData(IVertexConsumer consumer, Vector4f pos, Vector2f tex, Vector3f normal, Vector4f color, Vector2f light, TextureAtlasSprite texture) {
        ImmutableList elements = consumer.getVertexFormat().func_227894_c_();
        block10: for (int elem = 0; elem < elements.size(); ++elem) {
            VertexFormatElement e = (VertexFormatElement)elements.get(elem);
            switch (e.func_177375_c()) {
                case POSITION: {
                    consumer.put(elem, new float[]{pos.func_195910_a(), pos.func_195913_b(), pos.func_195914_c(), pos.func_195915_d()});
                    continue block10;
                }
                case COLOR: {
                    consumer.put(elem, new float[]{color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()});
                    continue block10;
                }
                case UV: {
                    switch (e.func_177369_e()) {
                        case 0: {
                            consumer.put(elem, new float[]{texture.func_94214_a((double)(tex.field_189982_i * 16.0f)), texture.func_94207_b((double)(tex.field_189983_j * 16.0f))});
                            continue block10;
                        }
                        case 2: {
                            consumer.put(elem, new float[]{light.field_189982_i, light.field_189983_j});
                            continue block10;
                        }
                    }
                    consumer.put(elem, new float[0]);
                    continue block10;
                }
                case NORMAL: {
                    consumer.put(elem, new float[]{normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c()});
                    continue block10;
                }
                default: {
                    consumer.put(elem, new float[0]);
                }
            }
        }
    }
}

