/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.model.FramedChestModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.data.LatchType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedChestLidModel
extends FramedBlockModel {
    private static final ResourceLocation TEXTURE = new ResourceLocation("framedblocks", "block/framed_chest_lock");
    private final Direction facing;
    private final LatchType latch;

    public FramedChestLidModel(BlockState state, IBakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        this.latch = (LatchType)((Object)state.func_177229_b(PropertyHolder.LATCH_TYPE));
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (quad.func_178210_d().func_176740_k() == Direction.Axis.Y) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, 0.0625f, 0.0625f, 0.9375f, 0.9375f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, quad.func_178210_d() == Direction.UP ? 0.875f : 0.4375f);
                quadMap.get(null).add(topBotQuad);
            }
        } else {
            BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(sideQuad, 0.0625f, 0.5625f, 0.9375f, 0.875f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.9375f);
                quadMap.get(null).add(sideQuad);
            }
        }
        if (this.latch == LatchType.CAMO) {
            FramedChestModel.makeChestLatch(quadMap, quad, this.facing);
        }
    }

    @Override
    protected boolean hasAdditionalQuadsInLayer(RenderType layer) {
        return this.latch == LatchType.DEFAULT && layer == RenderType.func_228643_e_();
    }

    @Override
    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, Random rand, IModelData data, RenderType layer) {
        List quads = this.baseModel.getQuads(state, null, rand, data);
        for (BakedQuad quad : quads) {
            if (!quad.func_187508_a().func_195668_m().equals((Object)TEXTURE)) continue;
            quadMap.get(null).add(quad);
        }
    }
}

