/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedInnerPrismCornerModel
extends FramedBlockModel {
    private final Direction dir;
    private final boolean top;
    private final boolean offset;

    public FramedInnerPrismCornerModel(BlockState state, IBakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        this.top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
        this.offset = (Boolean)state.func_177229_b((Property)PropertyHolder.OFFSET);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        BakedQuad triQuad;
        if (quad.func_178210_d() == Direction.DOWN && this.top || quad.func_178210_d() == Direction.UP && !this.top) {
            triQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomTriangleQuad(triQuad, this.dir)) {
                quadMap.get(quad.func_178210_d()).add(triQuad);
            }
        } else if ((quad.func_178210_d() == this.dir.func_176734_d() || quad.func_178210_d() == this.dir.func_176746_e()) && BakedQuadTransformer.createSideTriangleQuad(triQuad = ModelUtils.duplicateQuad(quad), quad.func_178210_d() == this.dir.func_176746_e(), this.top)) {
            quadMap.get(quad.func_178210_d()).add(triQuad);
        }
        if (quad.func_178210_d() == this.dir.func_176734_d()) {
            BakedQuad prismQuad = ModelUtils.duplicateQuad(quad);
            if (!this.offset) {
                if (BakedQuadTransformer.createPrismTriangleQuad(prismQuad, this.top, false)) {
                    quadMap.get(null).add(prismQuad);
                }
            } else {
                if (BakedQuadTransformer.createVerticalSideQuad(prismQuad, this.dir.func_176746_e(), 0.5f)) {
                    BakedQuadTransformer.offsetQuadInDir(prismQuad, this.dir.func_176746_e(), 0.5f);
                    if (BakedQuadTransformer.createPrismTriangleQuad(prismQuad, this.top, false)) {
                        quadMap.get(null).add(prismQuad);
                    }
                }
                if (BakedQuadTransformer.createVerticalSideQuad(prismQuad = ModelUtils.duplicateQuad(quad), this.dir.func_176735_f(), 0.5f)) {
                    BakedQuadTransformer.offsetQuadInDir(prismQuad, this.dir.func_176735_f(), 0.5f);
                    if (BakedQuadTransformer.createPrismTriangleQuad(prismQuad, this.top, false)) {
                        quadMap.get(null).add(prismQuad);
                    }
                }
            }
        }
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedInnerPrismCorner.get()).func_176223_P().func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

