/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.client.util.TriangleDirection;
import xfacthd.framedblocks.common.FBContent;

public class FramedPrismModel
extends FramedBlockModel {
    private final Direction facing;
    private final Direction.Axis axis;

    public FramedPrismModel(BlockState state, IBakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        this.axis = (Direction.Axis)state.func_177229_b((Property)BlockStateProperties.field_208148_A);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (this.isStateInvalid()) {
            quadMap.get(quad.func_178210_d()).add(quad);
            return;
        }
        Direction quadFace = quad.func_178210_d();
        if (this.facing.func_176740_k() == Direction.Axis.Y && quadFace.func_176740_k() != this.axis && quadFace.func_176740_k() != this.facing.func_176740_k()) {
            BakedQuad slope = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createHorizontalSideQuad(slope, this.facing == Direction.DOWN, 0.5f)) {
                BakedQuadTransformer.createTopBottomSlopeQuad(slope, this.facing == Direction.UP);
                quadMap.get(null).add(slope);
            }
        } else if (this.facing.func_176740_k() != Direction.Axis.Y && this.axis != Direction.Axis.Y && quadFace == this.facing) {
            BakedQuad slope = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createHorizontalSideQuad(slope, false, 0.5f)) {
                BakedQuadTransformer.createTopBottomSlopeQuad(slope, false);
                quadMap.get(null).add(slope);
            }
            if (BakedQuadTransformer.createHorizontalSideQuad(slope = ModelUtils.duplicateQuad(quad), true, 0.5f)) {
                BakedQuadTransformer.createTopBottomSlopeQuad(slope, true);
                quadMap.get(null).add(slope);
            }
        } else if (this.facing.func_176740_k() != Direction.Axis.Y && this.axis == Direction.Axis.Y && quadFace.func_176740_k() != this.axis && quadFace.func_176740_k() != this.facing.func_176740_k()) {
            BakedQuad slope = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createVerticalSideQuad(slope, this.facing, 0.5f)) {
                BakedQuadTransformer.createSideSlopeQuad(slope, quadFace == this.facing.func_176746_e());
                quadMap.get(null).add(slope);
            }
        } else if (quadFace.func_176740_k() == this.axis) {
            TriangleDirection triDir;
            if (this.facing.func_176740_k() == Direction.Axis.Y) {
                triDir = this.facing == Direction.UP ? TriangleDirection.UP : TriangleDirection.DOWN;
            } else if (this.axis != Direction.Axis.Y) {
                triDir = quadFace == this.facing.func_176746_e() ? TriangleDirection.RIGHT : TriangleDirection.LEFT;
            } else {
                BakedQuad triangle = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomSmallTriangleQuad(triangle, this.facing)) {
                    quadMap.get(quadFace).add(triangle);
                }
                return;
            }
            BakedQuad triangle = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSmallTriangleQuad(triangle, triDir)) {
                quadMap.get(quadFace).add(triangle);
            }
        }
    }

    private boolean isStateInvalid() {
        return this.axis == this.facing.func_176740_k();
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedPrism.get()).func_176223_P().func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.UP);
    }
}

