/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.Rotation;
import xfacthd.framedblocks.common.util.Utils;

public class FramedSlopePanelModel
extends FramedBlockModel {
    private static final float ANGLE = (float)Math.toDegrees(Math.atan(0.5));
    private final Direction facing;
    private final Rotation rotation;
    private final Direction orientation;
    private final boolean front;

    public FramedSlopePanelModel(BlockState state, IBakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        this.rotation = (Rotation)((Object)state.func_177229_b(PropertyHolder.ROTATION));
        this.orientation = this.rotation.withFacing(this.facing);
        this.front = (Boolean)state.func_177229_b((Property)PropertyHolder.FRONT);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction face = quad.func_178210_d();
        boolean yAxis = Utils.isY(this.orientation);
        if (face == this.orientation.func_176734_d()) {
            Direction cutDir = this.front ? this.facing : this.facing.func_176734_d();
            BakedQuad slabQuad = ModelUtils.duplicateQuad(quad);
            if (yAxis && BakedQuadTransformer.createTopBottomQuad(slabQuad, cutDir, 0.5f) || !yAxis && BakedQuadTransformer.createVerticalSideQuad(slabQuad, cutDir, 0.5f)) {
                quadMap.get(face).add(slabQuad);
            }
        } else if (face == this.facing.func_176734_d()) {
            BakedQuad slopeQuad = FramedSlopePanelModel.createSlope(quad, this.facing, this.orientation);
            if (!this.front) {
                BakedQuadTransformer.offsetQuadInDir(slopeQuad, this.facing, 0.5f);
            }
            quadMap.get(null).add(slopeQuad);
        } else if (face == this.facing) {
            if (this.front) {
                BakedQuad baseQuad = ModelUtils.duplicateQuad(quad);
                BakedQuadTransformer.setQuadPosInFacingDir(baseQuad, 0.5f);
                quadMap.get(null).add(baseQuad);
            }
        } else if (face != this.orientation) {
            float depth = this.front ? 1.0f : 0.5f;
            float offset = this.front ? 0.5f : 0.0f;
            BakedQuad triQuad = ModelUtils.duplicateQuad(quad);
            if (yAxis) {
                if (BakedQuadTransformer.createVerticalSideTriangleQuad(triQuad, face == this.facing.func_176746_e(), this.rotation == Rotation.DOWN, depth, offset)) {
                    if (this.front) {
                        BakedQuadTransformer.createVerticalSideQuad(triQuad, this.facing, 0.5f);
                    }
                    quadMap.get(face).add(triQuad);
                }
            } else if (BakedQuadTransformer.createTopBottomTriangleQuad(triQuad, this.facing.func_176734_d(), this.rotation == Rotation.RIGHT, depth, offset)) {
                if (this.front) {
                    BakedQuadTransformer.createTopBottomQuad(triQuad, this.facing, 0.5f);
                }
                quadMap.get(face).add(triQuad);
            }
        }
    }

    public static BakedQuad createSlope(BakedQuad quad, Direction facing, Direction orientation) {
        Preconditions.checkArgument((facing.func_176740_k() != orientation.func_176740_k() ? 1 : 0) != 0, (Object)"Directions must be perpendicular");
        Vector3f origin = new Vector3f(facing == Direction.WEST || Utils.isZ(facing) && orientation == Direction.WEST ? 1.0f : 0.0f, orientation == Direction.DOWN ? 1.0f : 0.0f, facing == Direction.NORTH || Utils.isX(facing) && orientation == Direction.NORTH ? 1.0f : 0.0f);
        float angle = Utils.isPositive(orientation) == Utils.isY(orientation) == Utils.isX(facing) == Utils.isPositive(facing) ? -ANGLE : ANGLE;
        BakedQuad slope = ModelUtils.duplicateQuad(quad);
        BakedQuadTransformer.rotateQuadAroundAxis(slope, Utils.isY(orientation) ? facing.func_176746_e().func_176740_k() : Direction.Axis.Y, origin, angle, true);
        return slope;
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedSlopePanel.get()).func_176223_P().func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

