/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.fonts.TextInputUtil;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.net.SignUpdatePacket;
import xfacthd.framedblocks.common.tileentity.FramedSignTileEntity;

@Mod.EventBusSubscriber(modid="framedblocks", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class FramedSignScreen
extends Screen {
    private static final Table<BlockState, Direction, TextureAtlasSprite> SPRITE_CACHE = HashBasedTable.create();
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("framedblocks", "block/framed_block");
    private static final ITextComponent DONE = new TranslationTextComponent("gui.done");
    private final FramedSignTileEntity sign;
    private final String[] lines = new String[4];
    private int blinkCounter = 0;
    private int currLine = 0;
    private TextInputUtil inputUtil;

    public FramedSignScreen(FramedSignTileEntity sign) {
        super((ITextComponent)new TranslationTextComponent("sign.edit"));
        this.sign = sign;
        for (int i = 0; i < 4; ++i) {
            this.lines[i] = sign.getLine(i).getString();
        }
    }

    protected void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 2 + 60, 200, 20, DONE, btn -> this.func_231175_as__()));
        this.inputUtil = new TextInputUtil(() -> this.lines[this.currLine], line -> {
            this.lines[this.currLine] = line;
            this.sign.setLine(this.currLine, (ITextComponent)new StringTextComponent(line));
        }, TextInputUtil.func_238570_a_((Minecraft)this.field_230706_i_), TextInputUtil.func_238582_c_((Minecraft)this.field_230706_i_), line -> this.field_230706_i_.field_71466_p.func_78256_a(line) <= 90);
    }

    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
        FramedBlocks.CHANNEL.sendToServer((Object)new SignUpdatePacket(this.sign.func_174877_v(), new String[]{this.sign.getLine(0).getString(), this.sign.getLine(1).getString(), this.sign.getLine(2).getString(), this.sign.getLine(3).getString()}));
    }

    public void func_231023_e_() {
        ++this.blinkCounter;
        if (!this.sign.func_200662_C().func_223045_a(this.sign.func_195044_w().func_177230_c())) {
            this.func_231164_f_();
        }
    }

    public boolean func_231042_a_(char character, int modifiers) {
        this.inputUtil.func_216894_a(character);
        return true;
    }

    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        if (key == 265) {
            this.currLine = this.currLine - 1 & 3;
            this.inputUtil.func_238588_f_();
            return true;
        }
        if (key == 264 || key == 257 || key == 335) {
            this.currLine = this.currLine + 1 & 3;
            this.inputUtil.func_238588_f_();
            return true;
        }
        return this.inputUtil.func_216897_a(key) || super.func_231046_a_(key, scanCode, modifiers);
    }

    public void func_230430_a_(MatrixStack mstack, int mouseX, int mouseY, float partialTicks) {
        RenderHelper.func_227783_c_();
        this.func_230446_a_(mstack);
        FramedSignScreen.func_238472_a_((MatrixStack)mstack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)40, (int)TextFormatting.WHITE.func_211163_e());
        this.field_230706_i_.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        TextureAtlasSprite sprite = this.getFrontSprite();
        int w = 128;
        int h = 64;
        int x = this.field_230708_k_ / 2 - w / 2;
        int y = this.field_230709_l_ / 2 - h / 2 - 20;
        FramedSignScreen.func_238461_a_((Matrix4f)mstack.func_227866_c_().func_227870_a_(), (int)x, (int)(x + w), (int)y, (int)(y + h), (int)this.func_230927_p_(), (float)sprite.func_94209_e(), (float)sprite.func_94212_f(), (float)sprite.func_94206_g(), (float)sprite.func_94207_b(8.0));
        mstack.func_227860_a_();
        mstack.func_227861_a_((double)this.field_230708_k_ / 2.0, (double)this.field_230709_l_ / 2.0 - 20.0, (double)this.func_230927_p_());
        mstack.func_227862_a_(1.2f, 1.2f, 1.0f);
        IRenderTypeBuffer.Impl buffer = this.field_230706_i_.func_228019_au_().func_228487_b_();
        this.drawLines(mstack.func_227866_c_().func_227870_a_(), buffer, this.lines);
        this.drawCursor(mstack, buffer, this.lines);
        mstack.func_227865_b_();
        RenderHelper.func_227784_d_();
        super.func_230430_a_(mstack, mouseX, mouseY, partialTicks);
    }

    private void drawLines(Matrix4f matrix, IRenderTypeBuffer.Impl buffer, String[] lines) {
        int color = this.sign.getTextColor().func_218388_g();
        for (int line = 0; line < lines.length; ++line) {
            String text = lines[line];
            if (text == null) continue;
            if (this.field_230712_o_.func_78260_a()) {
                text = this.field_230712_o_.func_147647_b(text);
            }
            float textX = (float)(-this.field_230712_o_.func_78256_a(text)) / 2.0f;
            this.field_230712_o_.func_228079_a_(text, textX, (float)(line * 10 - 20), color, false, matrix, (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
        }
        buffer.func_228461_a_();
    }

    private void drawCursor(MatrixStack mstack, IRenderTypeBuffer.Impl buffer, String[] lines) {
        Matrix4f matrix = mstack.func_227866_c_().func_227870_a_();
        int color = this.sign.getTextColor().func_218388_g();
        boolean blink = this.blinkCounter / 6 % 2 == 0;
        int dir = this.field_230712_o_.func_78260_a() ? -1 : 1;
        int y = this.currLine * 10 - 20;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line == null || i != this.currLine || this.inputUtil.func_216896_c() < 0) continue;
            int hw = this.field_230712_o_.func_78256_a(line) / 2;
            int selectionEnd = this.field_230712_o_.func_78256_a(line.substring(0, Math.max(Math.min(this.inputUtil.func_216896_c(), line.length()), 0)));
            int cursorX = (selectionEnd - hw) * dir;
            if (blink) {
                if (this.inputUtil.func_216896_c() < line.length()) {
                    FramedSignScreen.func_238467_a_((MatrixStack)mstack, (int)cursorX, (int)(y - 1), (int)(cursorX + 1), (int)(y + 9), (int)(0xFF000000 | color));
                } else {
                    this.field_230712_o_.func_228079_a_("_", (float)cursorX, (float)y, color, false, matrix, (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
                    buffer.func_228461_a_();
                }
            }
            if (this.inputUtil.func_216898_d() == this.inputUtil.func_216896_c()) continue;
            int x1 = (this.field_230712_o_.func_78256_a(line.substring(0, this.inputUtil.func_216898_d())) - hw) * dir;
            int x2 = (this.field_230712_o_.func_78256_a(line.substring(0, this.inputUtil.func_216896_c())) - hw) * dir;
            int xStart = Math.min(x1, x2);
            int xEnd = Math.max(x1, x2);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder tessBuffer = tessellator.func_178180_c();
            RenderSystem.disableTexture();
            RenderSystem.enableColorLogicOp();
            RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
            tessBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            tessBuffer.func_227888_a_(matrix, (float)xStart, (float)y + 9.0f, 0.0f).func_225586_a_(0, 0, 255, 255).func_181675_d();
            tessBuffer.func_227888_a_(matrix, (float)xEnd, (float)y + 9.0f, 0.0f).func_225586_a_(0, 0, 255, 255).func_181675_d();
            tessBuffer.func_227888_a_(matrix, (float)xEnd, (float)y - 1.0f, 0.0f).func_225586_a_(0, 0, 255, 255).func_181675_d();
            tessBuffer.func_227888_a_(matrix, (float)xStart, (float)y - 1.0f, 0.0f).func_225586_a_(0, 0, 255, 255).func_181675_d();
            tessBuffer.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)tessBuffer);
            RenderSystem.disableColorLogicOp();
            RenderSystem.enableTexture();
        }
    }

    private TextureAtlasSprite getFrontSprite() {
        Direction front;
        BlockState state = this.sign.func_195044_w();
        if (state.func_177230_c() == FBContent.blockFramedWallSign.get()) {
            front = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        } else {
            int rot = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208138_am);
            double angle = (double)rot * 360.0 / 16.0;
            front = Direction.func_176733_a((double)angle);
        }
        BlockState camoState = this.sign.getCamoState();
        if (camoState == Blocks.field_150350_a.func_176223_P()) {
            camoState = ((Block)FBContent.blockFramedCube.get()).func_176223_P();
        }
        if (!SPRITE_CACHE.contains((Object)camoState, (Object)front)) {
            IBakedModel model = this.field_230706_i_.func_175602_ab().func_184389_a(camoState);
            List quads = model.getQuads(camoState, front, this.field_230706_i_.field_71441_e.func_201674_k(), (IModelData)EmptyModelData.INSTANCE);
            TextureAtlasSprite sprite = !quads.isEmpty() ? ((BakedQuad)quads.get(0)).func_187508_a() : (TextureAtlasSprite)this.field_230706_i_.func_228015_a_(AtlasTexture.field_110575_b).apply(DEFAULT_TEXTURE);
            SPRITE_CACHE.put((Object)camoState, (Object)front, (Object)sprite);
        }
        return (TextureAtlasSprite)SPRITE_CACHE.get((Object)camoState, (Object)front);
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        SPRITE_CACHE.clear();
    }
}

