/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.util;

import java.util.Arrays;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class ModelUtils {
    private static final int ELEMENT_POS = ModelUtils.findElement(DefaultVertexFormats.field_181713_m);
    private static final int ELEMENT_COLOR = ModelUtils.findElement(DefaultVertexFormats.field_181714_n);
    private static final int ELEMENT_UV = ModelUtils.findElement(DefaultVertexFormats.field_181715_o);
    private static final int ELEMENT_LIGHT = ModelUtils.findElement(DefaultVertexFormats.field_227848_e_);
    private static final int ELEMENT_NORMAL = ModelUtils.findElement(DefaultVertexFormats.field_181717_q);

    public static boolean modifyQuad(BakedQuad quad, VertexDataConsumer consumer) {
        int[] vertexData = quad.func_178209_a();
        float[][] pos = new float[4][3];
        float[][] color = new float[4][4];
        float[][] uv = new float[4][2];
        float[][] light = new float[4][2];
        float[][] normal = new float[4][3];
        for (int vert = 0; vert < 4; ++vert) {
            LightUtil.unpack((int[])vertexData, (float[])pos[vert], (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)ELEMENT_POS);
            LightUtil.unpack((int[])vertexData, (float[])color[vert], (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)ELEMENT_COLOR);
            LightUtil.unpack((int[])vertexData, (float[])uv[vert], (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)ELEMENT_UV);
            LightUtil.unpack((int[])vertexData, (float[])light[vert], (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)ELEMENT_LIGHT);
            LightUtil.unpack((int[])vertexData, (float[])normal[vert], (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)ELEMENT_NORMAL);
        }
        boolean accept = consumer.accept(pos, color, uv, light, normal);
        if (!accept) {
            return false;
        }
        for (int vert = 0; vert < 4; ++vert) {
            LightUtil.pack((float[])pos[vert], (int[])vertexData, (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)ELEMENT_POS);
            LightUtil.pack((float[])color[vert], (int[])vertexData, (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)ELEMENT_COLOR);
            LightUtil.pack((float[])uv[vert], (int[])vertexData, (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)ELEMENT_UV);
            LightUtil.pack((float[])light[vert], (int[])vertexData, (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)ELEMENT_LIGHT);
            LightUtil.pack((float[])normal[vert], (int[])vertexData, (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)ELEMENT_NORMAL);
        }
        ModelUtils.fillNormal(quad);
        return true;
    }

    public static float[][] unpackElement(BakedQuad quad, VertexFormatElement element) {
        int elemPos = ModelUtils.findElement(element);
        float[][] data = new float[4][4];
        for (int vert = 0; vert < 4; ++vert) {
            LightUtil.unpack((int[])quad.func_178209_a(), (float[])data[vert], (VertexFormat)DefaultVertexFormats.field_176600_a, (int)vert, (int)elemPos);
        }
        return data;
    }

    public static int findElement(VertexFormatElement targetElement) {
        int idx = 0;
        for (VertexFormatElement element : DefaultVertexFormats.field_176600_a.func_227894_c_()) {
            if (element == targetElement) {
                return idx;
            }
            ++idx;
        }
        throw new IllegalArgumentException("Format doesn't have a " + targetElement + " element");
    }

    public static BakedQuad duplicateQuad(BakedQuad quad) {
        int[] vertexData = quad.func_178209_a();
        vertexData = Arrays.copyOf(vertexData, vertexData.length);
        return new BakedQuad(vertexData, quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), quad.func_239287_f_());
    }

    public static void fillNormal(BakedQuad quad) {
        float[][] pos = ModelUtils.unpackElement(quad, DefaultVertexFormats.field_181713_m);
        Vector3f v1 = new Vector3f(pos[3][0], pos[3][1], pos[3][2]);
        Vector3f t1 = new Vector3f(pos[1][0], pos[1][1], pos[1][2]);
        Vector3f v2 = new Vector3f(pos[2][0], pos[2][1], pos[2][2]);
        Vector3f t2 = new Vector3f(pos[0][0], pos[0][1], pos[0][2]);
        v1.func_195897_a(t1);
        v2.func_195897_a(t2);
        v2.func_195896_c(v1);
        v2.func_229194_d_();
        int x = (byte)Math.round(v2.func_195899_a() * 127.0f) & 0xFF;
        int y = (byte)Math.round(v2.func_195900_b() * 127.0f) & 0xFF;
        int z = (byte)Math.round(v2.func_195902_c() * 127.0f) & 0xFF;
        int normal = x | y << 8 | z << 16;
        int[] vertexData = quad.func_178209_a();
        int step = vertexData.length / 4;
        for (int vert = 0; vert < 4; ++vert) {
            vertexData[vert * step + 7] = normal;
        }
    }

    public static void remapUV(Direction quadDir, float coord1, float coord2, float coordTo, float[][] uv, int uv1, int uv2, int uvTo, boolean vAxis, boolean invert, boolean rotated, boolean mirrored) {
        ModelUtils.remapUV(quadDir, coord1, coord2, coordTo, uv, uv, uv1, uv2, uvTo, vAxis, invert, rotated, mirrored);
    }

    public static void remapUV(Direction quadDir, float coord1, float coord2, float coordTo, float[][] uvSrc, float[][] uvDest, int uv1, int uv2, int uvTo, boolean vAxis, boolean invert, boolean rotated, boolean mirrored) {
        if (rotated) {
            if (quadDir == Direction.UP) {
                invert = vAxis == mirrored;
            } else if (quadDir == Direction.DOWN) {
                invert = !mirrored;
            } else if (quadDir.func_176743_c() == Direction.AxisDirection.POSITIVE != vAxis) {
                invert = !invert;
            }
        } else if (mirrored) {
            if (quadDir == Direction.UP) {
                invert = !vAxis || uvSrc[0][1] > uvSrc[1][1];
            } else if (quadDir == Direction.DOWN) {
                invert = !vAxis || uvSrc[0][1] < uvSrc[1][1];
            } else if (!vAxis) {
                invert = !invert;
            }
        }
        float coordMin = Math.min(coord1, coord2);
        float coordMax = Math.max(coord1, coord2);
        int uvIdx = rotated != vAxis ? 1 : 0;
        float uvMin = Math.min(uvSrc[uv1][uvIdx], uvSrc[uv2][uvIdx]);
        float uvMax = Math.max(uvSrc[uv1][uvIdx], uvSrc[uv2][uvIdx]);
        if (coordTo == coordMin) {
            uvDest[uvTo][uvIdx] = invert ? uvMax : uvMin;
        } else if (coordTo == coordMax) {
            uvDest[uvTo][uvIdx] = invert ? uvMin : uvMax;
        } else {
            float mult = (coordTo - coordMin) / (coordMax - coordMin);
            if (invert) {
                mult = 1.0f - mult;
            }
            uvDest[uvTo][uvIdx] = MathHelper.func_219799_g((float)mult, (float)uvMin, (float)uvMax);
        }
    }

    public static boolean isQuadRotated(float[][] uv) {
        return !(!MathHelper.func_180185_a((float)uv[0][1], (float)uv[1][1]) && !MathHelper.func_180185_a((float)uv[3][1], (float)uv[2][1]) || !MathHelper.func_180185_a((float)uv[1][0], (float)uv[2][0]) && !MathHelper.func_180185_a((float)uv[0][0], (float)uv[3][0]));
    }

    public static boolean isQuadMirrored(float[][] uv) {
        boolean rotated = ModelUtils.isQuadRotated(uv);
        if (!rotated) {
            return uv[0][0] > uv[3][0] && uv[1][0] > uv[2][0] || uv[0][1] > uv[1][1] && uv[3][1] > uv[2][1];
        }
        return uv[0][0] > uv[1][0] && uv[3][0] > uv[2][0] || uv[0][1] < uv[3][1] && uv[1][1] < uv[2][1];
    }

    public static BakedQuad invertTintIndex(BakedQuad quad) {
        return new BakedQuad(quad.func_178209_a(), ModelUtils.encodeSecondaryTintIndex(quad.func_178211_c()), quad.func_178210_d(), quad.func_187508_a(), quad.func_239287_f_());
    }

    public static int encodeSecondaryTintIndex(int tintIndex) {
        return (tintIndex + 2) * -1;
    }

    public static int decodeSecondaryTintIndex(int tintIndex) {
        return tintIndex * -1 - 2;
    }

    public static interface VertexDataConsumer {
        public boolean accept(float[][] var1, float[][] var2, float[][] var3, float[][] var4, float[][] var5);
    }
}

