/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.FramedRailSlopeBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;
import xfacthd.framedblocks.common.util.CtmPredicate;
import xfacthd.framedblocks.common.util.Utils;

public class FramedSlopeBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, dir) -> {
        SlopeType type = Utils.getSlopeType(state);
        if (dir == Direction.UP && type == SlopeType.TOP) {
            return true;
        }
        if (dir == Direction.DOWN && type == SlopeType.BOTTOM) {
            return true;
        }
        if (type == SlopeType.HORIZONTAL) {
            Direction facing = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
            return dir == facing || dir == facing.func_176735_f();
        }
        return Utils.getBlockFacing(state) == dir;
    };
    public static final VoxelShape SHAPE_BOTTOM = VoxelShapes.func_216384_a((VoxelShape)FramedSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopeBlock.func_208617_a((double)0.0, (double)0.5, (double)0.0, (double)16.0, (double)4.0, (double)15.5), FramedSlopeBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), FramedSlopeBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), FramedSlopeBlock.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.5, (double)4.0), FramedSlopeBlock.func_208617_a((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)0.5)}).func_197753_c();
    public static final VoxelShape SHAPE_TOP = VoxelShapes.func_216384_a((VoxelShape)FramedSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)0.5), (VoxelShape[])new VoxelShape[]{FramedSlopeBlock.func_208617_a((double)0.0, (double)0.5, (double)0.0, (double)16.0, (double)4.0, (double)4.0), FramedSlopeBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), FramedSlopeBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)12.0), FramedSlopeBlock.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.5, (double)15.5), FramedSlopeBlock.func_208617_a((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0)}).func_197753_c();
    public static final VoxelShape SHAPE_HORIZONTAL = VoxelShapes.func_216384_a((VoxelShape)FramedSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)15.5), FramedSlopeBlock.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)12.0), FramedSlopeBlock.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0), FramedSlopeBlock.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)4.0), FramedSlopeBlock.func_208617_a((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.5)}).func_197753_c();

    public FramedSlopeBlock() {
        super(BlockType.FRAMED_SLOPE);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PropertyHolder.FACING_HOR, PropertyHolder.SLOPE_TYPE, BlockStateProperties.field_208198_y, PropertyHolder.SOLID, PropertyHolder.GLOWING});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.withSlopeType(this.func_176223_P(), context.func_196000_l(), context.func_195992_f(), context.func_221532_j());
        return FramedSlopeBlock.withWater(state, (IWorldReader)context.func_195991_k(), context.func_195995_a());
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_221742_cg) {
            Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
            SlopeType type = (SlopeType)((Object)state.func_177229_b(PropertyHolder.SLOPE_TYPE));
            Direction face = hit.func_216354_b();
            if (type == SlopeType.BOTTOM && (face == dir.func_176734_d() || face == Direction.UP)) {
                BlockState newState;
                Block railSlope = (Block)FBContent.blockFramedRailSlope.get();
                if (!railSlope.func_196260_a(newState = (BlockState)((BlockState)railSlope.func_176223_P().func_206870_a(PropertyHolder.ASCENDING_RAIL_SHAPE, (Comparable)FramedRailSlopeBlock.shapeFromDirection(dir))).func_206870_a((Property)BlockStateProperties.field_208198_y, state.func_177229_b((Property)BlockStateProperties.field_208198_y)), (IWorldReader)world, pos)) {
                    return ActionResultType.FAIL;
                }
                if (!world.func_201670_d()) {
                    BlockState camoState = Blocks.field_150350_a.func_176223_P();
                    ItemStack camoStack = ItemStack.field_190927_a;
                    boolean glowing = false;
                    boolean intangible = false;
                    TileEntity te = world.func_175625_s(pos);
                    if (te instanceof FramedTileEntity) {
                        camoState = ((FramedTileEntity)te).getCamoState();
                        camoStack = ((FramedTileEntity)te).getCamoStack();
                        glowing = ((FramedTileEntity)te).isGlowing();
                        intangible = ((FramedTileEntity)te).isIntangible(null);
                    }
                    world.func_175656_a(pos, newState);
                    SoundType sound = Blocks.field_150448_aq.func_220072_p(Blocks.field_150448_aq.func_176223_P());
                    world.func_184133_a(null, pos, sound.func_185841_e(), SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                        player.field_71071_by.func_70296_d();
                    }
                    if ((te = world.func_175625_s(pos)) instanceof FramedTileEntity) {
                        ((FramedTileEntity)te).setCamo(camoStack, camoState, false);
                        ((FramedTileEntity)te).setGlowing(glowing);
                        ((FramedTileEntity)te).setIntangible(intangible);
                    }
                }
                return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
            }
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            SlopeType type = Utils.getSlopeType(state);
            Direction dir = Utils.getBlockFacing(state);
            if (type == SlopeType.BOTTOM) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, SHAPE_BOTTOM));
                continue;
            }
            if (type == SlopeType.TOP) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, SHAPE_TOP));
                continue;
            }
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, SHAPE_HORIZONTAL));
        }
        return builder.build();
    }
}

