/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.StairsBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IWorld;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.FramedHalfStairsBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.StairsType;
import xfacthd.framedblocks.common.util.CtmPredicate;
import xfacthd.framedblocks.common.util.Utils;

public class FramedVerticalStairsBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, side) -> {
        StairsType type = (StairsType)((Object)((Object)state.func_177229_b(PropertyHolder.STAIRS_TYPE)));
        if (type == StairsType.VERTICAL) {
            Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
            return side == dir || side == dir.func_176735_f();
        }
        return false;
    };

    public FramedVerticalStairsBlock() {
        super(BlockType.FRAMED_VERTICAL_STAIRS);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PropertyHolder.FACING_HOR, PropertyHolder.STAIRS_TYPE, BlockStateProperties.field_208198_y, PropertyHolder.SOLID, PropertyHolder.GLOWING});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = (BlockState)this.func_176223_P().func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)context.func_195992_f());
        return this.getStateFromContext(state, (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (facing == dir.func_176734_d() || facing == dir.func_176746_e()) {
            return state;
        }
        return this.getStateFromContext(state, world, pos);
    }

    private BlockState getStateFromContext(BlockState state, IWorld world, BlockPos pos) {
        boolean top;
        Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        BlockState front = world.func_180495_p(pos.func_177972_a(dir));
        BlockState left = world.func_180495_p(pos.func_177972_a(dir.func_176735_f()));
        if (FramedVerticalStairsBlock.isNoStair(front) && FramedVerticalStairsBlock.isNoStair(left)) {
            return (BlockState)state.func_206870_a(PropertyHolder.STAIRS_TYPE, (Comparable)((Object)StairsType.VERTICAL));
        }
        boolean topCorner = false;
        boolean bottomCorner = false;
        if (front.func_177230_c() instanceof StairsBlock && front.func_177229_b((Property)BlockStateProperties.field_208157_J) == dir.func_176735_f()) {
            topCorner = front.func_177229_b((Property)BlockStateProperties.field_208164_Q) == Half.BOTTOM;
            bottomCorner = front.func_177229_b((Property)BlockStateProperties.field_208164_Q) == Half.TOP;
        } else if (front.func_177230_c() instanceof FramedHalfStairsBlock && front.func_177229_b((Property)PropertyHolder.FACING_HOR) == dir.func_176735_f()) {
            top = (Boolean)front.func_177229_b((Property)PropertyHolder.TOP);
            if (!((Boolean)front.func_177229_b((Property)PropertyHolder.RIGHT)).booleanValue()) {
                topCorner = !top;
                bottomCorner = top;
            }
        }
        if (left.func_177230_c() instanceof StairsBlock && left.func_177229_b((Property)BlockStateProperties.field_208157_J) == dir) {
            topCorner |= left.func_177229_b((Property)BlockStateProperties.field_208164_Q) == Half.BOTTOM;
            bottomCorner |= left.func_177229_b((Property)BlockStateProperties.field_208164_Q) == Half.TOP;
        } else if (left.func_177230_c() instanceof FramedHalfStairsBlock && left.func_177229_b((Property)PropertyHolder.FACING_HOR) == dir) {
            top = (Boolean)left.func_177229_b((Property)PropertyHolder.TOP);
            if (((Boolean)left.func_177229_b((Property)PropertyHolder.RIGHT)).booleanValue()) {
                topCorner = !top;
                bottomCorner = top;
            }
        }
        BlockState above = world.func_180495_p(pos.func_177984_a());
        BlockState below = world.func_180495_p(pos.func_177977_b());
        StairsType type = topCorner && !above.func_203425_a((Block)this) ? StairsType.TOP_CORNER : (bottomCorner && !below.func_203425_a((Block)this) ? StairsType.BOTTOM_CORNER : StairsType.VERTICAL);
        return (BlockState)state.func_206870_a(PropertyHolder.STAIRS_TYPE, (Comparable)((Object)type));
    }

    private static boolean isNoStair(BlockState state) {
        return !(state.func_177230_c() instanceof StairsBlock) && !(state.func_177230_c() instanceof FramedHalfStairsBlock);
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape vertShape = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        VoxelShape topCornerShape = Stream.of(Block.func_208617_a((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
        VoxelShape bottomCornerShape = Stream.of(Block.func_208617_a((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), Block.func_208617_a((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
        for (BlockState state : states) {
            StairsType type = (StairsType)((Object)state.func_177229_b(PropertyHolder.STAIRS_TYPE));
            Direction dir = ((Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR)).func_176734_d();
            if (type == StairsType.TOP_CORNER) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, topCornerShape));
                continue;
            }
            if (type == StairsType.BOTTOM_CORNER) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, bottomCornerShape));
                continue;
            }
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, vertShape));
        }
        return builder.build();
    }
}

