/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public class ElevatedSlopeSlabSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
        if (side == dir || top && side == Direction.UP || !top && side == Direction.DOWN) {
            return SideSkipPredicate.CTM.test(world, pos, state, adjState, side);
        }
        if (!(adjState.func_177230_c() instanceof IFramedBlock)) {
            return false;
        }
        BlockType adjBlock = ((IFramedBlock)adjState.func_177230_c()).getBlockType();
        switch (adjBlock) {
            case FRAMED_ELEVATED_SLOPE_SLAB: {
                return ElevatedSlopeSlabSkipPredicate.testAgainstElevatedSlopeSlab(world, pos, dir, top, adjState, side);
            }
            case FRAMED_SLOPE_SLAB: 
            case FRAMED_DOUBLE_SLOPE_SLAB: {
                return ElevatedSlopeSlabSkipPredicate.testAgainstSlopeSlab(world, pos, dir, top, adjState, side);
            }
            case FRAMED_INV_DOUBLE_SLOPE_SLAB: {
                return ElevatedSlopeSlabSkipPredicate.testAgainstInverseDoubleSlopeSlab(world, pos, dir, top, adjState, side);
            }
            case FRAMED_SLAB: {
                return ElevatedSlopeSlabSkipPredicate.testAgainstSlab(world, pos, dir, top, adjState, side);
            }
            case FRAMED_DOUBLE_SLAB: {
                return ElevatedSlopeSlabSkipPredicate.testAgainstDoubleSlab(world, pos, dir, top, side);
            }
            case FRAMED_SLAB_EDGE: {
                return ElevatedSlopeSlabSkipPredicate.testAgainstSlabEdge(world, pos, dir, top, adjState, side);
            }
            case FRAMED_STAIRS: {
                return ElevatedSlopeSlabSkipPredicate.testAgainstStairs(world, pos, dir, top, adjState, side);
            }
            case FRAMED_VERTICAL_HALF_STAIRS: {
                return ElevatedSlopeSlabSkipPredicate.testAgainstVerticalHalfStairs(world, pos, dir, top, adjState, side);
            }
        }
        return false;
    }

    private static boolean testAgainstElevatedSlopeSlab(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (adjTop != top) {
            return false;
        }
        if (side == dir.func_176746_e() || side == dir.func_176735_f()) {
            return adjDir == dir && SideSkipPredicate.compareState(world, pos, side);
        }
        if (side == dir.func_176734_d()) {
            return adjDir == dir.func_176734_d() && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlopeSlab(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP_HALF);
        return side == dir.func_176734_d() && adjDir == dir && adjTopHalf == top && SideSkipPredicate.compareState(world, pos, side);
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (side != dir.func_176734_d()) {
            return false;
        }
        return (adjDir == dir && top || adjDir == dir.func_176734_d() && !top) && SideSkipPredicate.compareState(world, pos, side);
    }

    private static boolean testAgainstSlab(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        return adjTop == top && side == dir.func_176734_d() && SideSkipPredicate.compareState(world, pos, side);
    }

    private static boolean testAgainstDoubleSlab(IBlockReader world, BlockPos pos, Direction dir, boolean top, Direction side) {
        return side == dir.func_176734_d() && SideSkipPredicate.compareState(world, pos, side, top ? Direction.UP : Direction.DOWN);
    }

    private static boolean testAgainstSlabEdge(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        return adjDir == dir && adjTop == top && side == dir.func_176734_d() && SideSkipPredicate.compareState(world, pos, side);
    }

    private static boolean testAgainstStairs(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.func_177229_b((Property)BlockStateProperties.field_208157_J);
        StairsShape adjShape = (StairsShape)adjState.func_177229_b((Property)BlockStateProperties.field_208146_au);
        boolean bl = adjTop = adjState.func_177229_b((Property)BlockStateProperties.field_208164_Q) == Half.TOP;
        if (adjTop != top || side != dir.func_176734_d()) {
            return false;
        }
        return StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.func_176734_d()) && SideSkipPredicate.compareState(world, pos, side);
    }

    private static boolean testAgainstVerticalHalfStairs(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (side != dir.func_176734_d() || adjTop != top) {
            return false;
        }
        if (adjDir == dir || adjDir == dir.func_176746_e()) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }
}

