/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.item;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.FramedToolType;
import xfacthd.framedblocks.common.item.FramedToolItem;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;
import xfacthd.framedblocks.common.util.ServerConfig;

public class FramedBlueprintItem
extends FramedToolItem {
    public static final String CONTAINED_BLOCK = "desc.framed_blocks:blueprint_block";
    public static final String CAMO_BLOCK = "desc.framed_blocks:blueprint_camo";
    public static final String IS_ILLUMINATED = "desc.framed_blocks:blueprint_illuminated";
    public static final IFormattableTextComponent BLOCK_NONE = new TranslationTextComponent("desc.framed_blocks:blueprint_none").func_240699_a_(TextFormatting.RED);
    public static final IFormattableTextComponent BLOCK_INVALID = new TranslationTextComponent("desc.framed_blocks:blueprint_invalid").func_240699_a_(TextFormatting.RED);
    public static final IFormattableTextComponent ILLUMINATED_FALSE = new TranslationTextComponent("desc.framed_blocks:blueprint_illuminated_false").func_240699_a_(TextFormatting.RED);
    public static final IFormattableTextComponent ILLUMINATED_TRUE = new TranslationTextComponent("desc.framed_blocks:blueprint_illuminated_true").func_240699_a_(TextFormatting.GREEN);
    public static final IFormattableTextComponent CANT_COPY = new TranslationTextComponent("desc.framed_blocks:blueprint_cant_copy").func_240699_a_(TextFormatting.RED);

    public FramedBlueprintItem(FramedToolType type) {
        super(type);
    }

    @Override
    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            if (!world.func_201670_d()) {
                CompoundNBT tag = stack.func_190925_c("blueprint_data");
                tag.func_82580_o("framed_block");
                tag.func_82580_o("camo_data");
                tag.func_82580_o("camo_data_two");
            }
            return ActionResult.func_233538_a_((Object)stack, (boolean)world.func_201670_d());
        }
        return super.func_77659_a(world, player, hand);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.FAIL;
        }
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        CompoundNBT tag = context.func_195996_i().func_190925_c("blueprint_data");
        if (player.func_225608_bj_()) {
            return this.writeBlueprint(world, pos, tag);
        }
        if (!tag.isEmpty()) {
            return this.readBlueprint(context, player, tag);
        }
        return super.func_195939_a(context);
    }

    private ActionResultType writeBlueprint(World world, BlockPos pos, CompoundNBT tag) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof FramedTileEntity)) {
            return ActionResultType.FAIL;
        }
        if (!world.func_201670_d()) {
            BlockState state = world.func_180495_p(pos);
            String block = state.func_177230_c().getRegistryName().toString();
            tag.func_74778_a("framed_block", block);
            CompoundNBT nbt = ((FramedTileEntity)te).writeToBlueprint();
            if (state.func_177230_c() == FBContent.blockFramedDoor.get()) {
                boolean top = state.func_177229_b((Property)BlockStateProperties.field_208163_P) == DoubleBlockHalf.UPPER;
                BlockPos posTwo = top ? pos.func_177977_b() : pos.func_177984_a();
                TileEntity teTwo = world.func_175625_s(posTwo);
                CompoundNBT nbtTwo = teTwo instanceof FramedTileEntity ? ((FramedTileEntity)teTwo).writeToBlueprint() : new CompoundNBT();
                tag.func_218657_a("camo_data", (INBT)(top ? nbtTwo : nbt));
                tag.func_218657_a("camo_data_two", (INBT)(top ? nbt : nbtTwo));
            } else {
                tag.func_218657_a("camo_data", (INBT)nbt);
            }
        }
        return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
    }

    private ActionResultType readBlueprint(ItemUseContext context, PlayerEntity player, CompoundNBT tag) {
        Block block = this.getTargetBlock(context.func_195996_i());
        if (block.func_176223_P().func_196958_f()) {
            return ActionResultType.FAIL;
        }
        Item item = block.func_199767_j();
        if (!(item instanceof BlockItem)) {
            return ActionResultType.FAIL;
        }
        if (this.checkMissingMaterials(player, item, tag)) {
            return ActionResultType.FAIL;
        }
        return this.tryPlace(context, player, item, tag);
    }

    private boolean checkMissingMaterials(PlayerEntity player, Item item, CompoundNBT tag) {
        int count;
        if (player.field_71075_bZ.field_75098_d) {
            return false;
        }
        CompoundNBT camoData = tag.func_74775_l("camo_data");
        ItemStack camo = ItemStack.func_199557_a((CompoundNBT)camoData.func_74775_l("camo_stack"));
        ItemStack camoTwo = camoData.func_74764_b("camo_stack_two") ? ItemStack.func_199557_a((CompoundNBT)camoData.func_74775_l("camo_stack_two")) : ItemStack.field_190927_a;
        boolean glowstone = camoData.func_74767_n("glowing");
        boolean intangible = camoData.func_74767_n("intangible");
        boolean doubleBlock = false;
        if (item == ((Block)FBContent.blockFramedDoor.get()).func_199767_j() && tag.func_74764_b("camo_data_two")) {
            camoTwo = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("camo_data_two").func_74775_l("camo_stack"));
        } else if (item == ((Block)FBContent.blockFramedDoublePanel.get()).func_199767_j()) {
            item = ((Block)FBContent.blockFramedPanel.get()).func_199767_j();
            doubleBlock = true;
        } else if (item == ((Block)FBContent.blockFramedDoubleSlab.get()).func_199767_j()) {
            item = ((Block)FBContent.blockFramedSlab.get()).func_199767_j();
            doubleBlock = true;
        }
        if (doubleBlock ? (count = player.field_71071_by.func_213901_a(item)) < 2 : !player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)item))) {
            return true;
        }
        if (!camo.func_190926_b() && camo.func_77973_b() == camoTwo.func_77973_b()) {
            count = player.field_71071_by.func_213901_a(camo.func_77973_b());
            if (count < 2) {
                return true;
            }
        } else {
            if (!camo.func_190926_b() && !player.field_71071_by.func_70431_c(camo)) {
                return true;
            }
            if (!camoTwo.func_190926_b() && !player.field_71071_by.func_70431_c(camoTwo)) {
                return true;
            }
        }
        if (glowstone && !player.field_71071_by.func_199712_a((ITag)Tags.Items.DUSTS_GLOWSTONE)) {
            return true;
        }
        return intangible && !player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)ServerConfig.intangibleMarkerItem));
    }

    private ActionResultType tryPlace(ItemUseContext context, PlayerEntity player, Item item, CompoundNBT tag) {
        ItemStack dummyStack = new ItemStack((IItemProvider)item, 1);
        dummyStack.func_196082_o().func_218657_a("BlockEntityTag", (INBT)tag.func_74775_l("camo_data").func_74737_b());
        ItemUseContext placeContext = new ItemUseContext(context.func_195991_k(), context.func_195999_j(), context.func_221531_n(), dummyStack, new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), context.func_195995_a(), context.func_221533_k()));
        BlockPos topPos = new BlockItemUseContext(placeContext).func_195995_a().func_177984_a();
        ActionResultType result = item.func_195939_a(placeContext);
        if (!context.func_195991_k().func_201670_d() && result.func_226246_a_()) {
            if (item == ((Block)FBContent.blockFramedDoor.get()).func_199767_j() && context.func_195991_k().func_175625_s(topPos) instanceof FramedTileEntity && tag.func_150297_b("camo_data_two", 10)) {
                dummyStack.func_196082_o().func_218657_a("BlockEntityTag", tag.func_74781_a("camo_data_two"));
                BlockItem.func_179224_a((World)context.func_195991_k(), (PlayerEntity)context.func_195999_j(), (BlockPos)topPos, (ItemStack)dummyStack);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                this.consumeItems(player, item, tag);
            }
        }
        return result;
    }

    private void consumeItems(PlayerEntity player, Item item, CompoundNBT tag) {
        CompoundNBT camoData = tag.func_74775_l("camo_data");
        ItemStack camo = ItemStack.func_199557_a((CompoundNBT)camoData.func_74775_l("camo_stack"));
        ItemStack camoTwo = camoData.func_74764_b("camo_stack_two") ? ItemStack.func_199557_a((CompoundNBT)camoData.func_74775_l("camo_stack_two")) : ItemStack.field_190927_a;
        boolean glowstone = camoData.func_74767_n("glowing");
        boolean intangible = camoData.func_74767_n("intangible");
        boolean doubleBlock = false;
        if (item == ((Block)FBContent.blockFramedDoor.get()).func_199767_j() && tag.func_74764_b("camo_data_two")) {
            camoTwo = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("camo_data_two").func_74775_l("camo_stack"));
        } else if (item == ((Block)FBContent.blockFramedDoublePanel.get()).func_199767_j()) {
            item = ((Block)FBContent.blockFramedPanel.get()).func_199767_j();
            doubleBlock = true;
        } else if (item == ((Block)FBContent.blockFramedDoubleSlab.get()).func_199767_j()) {
            item = ((Block)FBContent.blockFramedSlab.get()).func_199767_j();
            doubleBlock = true;
        }
        int remainingBlock = doubleBlock ? 2 : 1;
        boolean foundCamo = false;
        boolean foundCamoTwo = false;
        boolean foundGlowstone = false;
        boolean foundIntangibleMarker = false;
        PlayerInventory inv = player.field_71071_by;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (remainingBlock > 0 && stack.func_77973_b() == item) {
                int size = stack.func_190916_E();
                stack.func_190918_g(Math.min(remainingBlock, size));
                remainingBlock -= size - stack.func_190916_E();
                inv.func_70296_d();
            }
            if (!foundCamo && !camo.func_190926_b() && stack.func_77973_b() == camo.func_77973_b()) {
                foundCamo = true;
                stack.func_190918_g(1);
                inv.func_70296_d();
            }
            if (!(foundCamoTwo || camoTwo.func_190926_b() || stack.func_77973_b() != camoTwo.func_77973_b() || stack.func_190926_b())) {
                foundCamoTwo = true;
                stack.func_190918_g(1);
                inv.func_70296_d();
            }
            if (!foundGlowstone && glowstone && stack.func_77973_b().func_206844_a((ITag)Tags.Items.DUSTS_GLOWSTONE)) {
                foundGlowstone = true;
                stack.func_190918_g(1);
                inv.func_70296_d();
            }
            if (!foundIntangibleMarker && intangible && stack.func_77973_b() == ServerConfig.intangibleMarkerItem) {
                foundIntangibleMarker = true;
                stack.func_190918_g(1);
                inv.func_70296_d();
            }
            if (!(remainingBlock > 0 || !camo.func_190926_b() && !foundCamo || !camoTwo.func_190926_b() && !foundCamoTwo || glowstone && !foundGlowstone || intangible && !foundIntangibleMarker)) break;
        }
    }

    public Block getTargetBlock(ItemStack stack) {
        CompoundNBT tag = stack.func_190925_c("blueprint_data");
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tag.func_74779_i("framed_block")));
        Objects.requireNonNull(block);
        return block;
    }

    public void func_77624_a(ItemStack stack, @Nullable World level, List<ITextComponent> components, ITooltipFlag flag) {
        CompoundNBT tag = stack.func_190925_c("blueprint_data");
        if (tag.isEmpty()) {
            components.add((ITextComponent)new TranslationTextComponent(CONTAINED_BLOCK, new Object[]{BLOCK_NONE}).func_240699_a_(TextFormatting.GOLD));
        } else {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tag.func_74779_i("framed_block")));
            IFormattableTextComponent blockName = block == null ? BLOCK_INVALID : block.func_235333_g_().func_240699_a_(TextFormatting.WHITE);
            CompoundNBT beTag = tag.func_74775_l("camo_data");
            IFormattableTextComponent camoName = !(block instanceof IFramedBlock) ? BLOCK_NONE : ((IFramedBlock)block).printCamoBlock(beTag);
            IFormattableTextComponent illuminated = beTag.func_74767_n("glowing") ? ILLUMINATED_TRUE : ILLUMINATED_FALSE;
            IFormattableTextComponent lineOne = new TranslationTextComponent(CONTAINED_BLOCK, new Object[]{blockName}).func_240699_a_(TextFormatting.GOLD);
            IFormattableTextComponent lineTwo = new TranslationTextComponent(CAMO_BLOCK, new Object[]{camoName}).func_240699_a_(TextFormatting.GOLD);
            IFormattableTextComponent lineThree = new TranslationTextComponent(IS_ILLUMINATED, new Object[]{illuminated}).func_240699_a_(TextFormatting.GOLD);
            components.addAll(Arrays.asList(lineOne, lineTwo, lineThree));
        }
    }
}

