/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.tileentity;

import java.util.Arrays;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.model.data.ModelProperty;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.CollapseFace;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;
import xfacthd.framedblocks.common.util.MathUtils;
import xfacthd.framedblocks.common.util.Utils;

public class FramedCollapsibleTileEntity
extends FramedTileEntity {
    public static final ModelProperty<Integer> OFFSETS = new ModelProperty();
    public static final ModelProperty<Direction> COLLAPSED_FACE = new ModelProperty();
    private Direction collapsedFace = null;
    private byte[] vertexOffsets = new byte[4];

    public FramedCollapsibleTileEntity() {
        super((TileEntityType)FBContent.tileTypeFramedCollapsibleBlock.get());
    }

    public void handleDeform(PlayerEntity player) {
        RayTraceResult hit = player.func_213324_a(10.0, 0.0f, false);
        if (!(hit instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult blockHit = (BlockRayTraceResult)hit;
        Direction faceHit = blockHit.func_216354_b();
        Vector3d hitLoc = Utils.fraction(hit.func_216347_e());
        if (this.collapsedFace != null && faceHit != this.collapsedFace) {
            return;
        }
        int vert = FramedCollapsibleTileEntity.vertexFromHit(faceHit, hitLoc);
        if (player.func_225608_bj_() && this.collapsedFace != null && this.vertexOffsets[vert] > 0) {
            byte target = (byte)(this.vertexOffsets[vert] - 1);
            this.applyDeformation(vert, target, faceHit);
            this.deformNeighbors(faceHit, hitLoc, target);
        } else if (!player.func_225608_bj_() && this.vertexOffsets[vert] < 16) {
            byte target = (byte)(this.vertexOffsets[vert] + 1);
            this.applyDeformation(vert, target, faceHit);
            this.deformNeighbors(faceHit, hitLoc, target);
        }
    }

    private void applyDeformation(int vertex, byte offset, Direction faceHit) {
        if ((offset = (byte)MathHelper.func_76125_a((int)offset, (int)0, (int)16)) == this.vertexOffsets[vertex]) {
            return;
        }
        this.vertexOffsets[vertex] = offset;
        if (offset == 0) {
            boolean noOffsets = true;
            for (int i = 0; i < 4; ++i) {
                if (this.vertexOffsets[i] <= 0) continue;
                noOffsets = false;
                break;
            }
            if (noOffsets) {
                this.collapsedFace = null;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(PropertyHolder.COLLAPSED_FACE, (Comparable)((Object)CollapseFace.NONE)), 3);
            } else {
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        } else if (this.collapsedFace == null) {
            this.collapsedFace = faceHit;
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(PropertyHolder.COLLAPSED_FACE, (Comparable)((Object)CollapseFace.fromDirection(this.collapsedFace))), 3);
        } else {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
        this.func_70296_d();
    }

    private void deformNeighbors(Direction faceHit, Vector3d hitLoc, byte offset) {
        BlockPos[] neighbors = new BlockPos[3];
        Vector3d[] hitVecs = new Vector3d[3];
        if (faceHit.func_176740_k() == Direction.Axis.Y) {
            Direction dirX = hitLoc.field_72450_a > 0.5 ? Direction.EAST : Direction.WEST;
            Direction dirZ = hitLoc.field_72449_c > 0.5 ? Direction.SOUTH : Direction.NORTH;
            neighbors[0] = this.field_174879_c.func_177972_a(dirX);
            neighbors[1] = this.field_174879_c.func_177972_a(dirZ);
            neighbors[2] = neighbors[0].func_177972_a(dirZ);
            hitVecs[0] = hitLoc.func_72441_c((double)dirX.func_82601_c() * 0.5, 0.0, 0.0);
            hitVecs[1] = hitLoc.func_72441_c(0.0, 0.0, (double)dirZ.func_82599_e() * 0.5);
            hitVecs[2] = hitVecs[0].func_72441_c(0.0, 0.0, (double)dirZ.func_82599_e() * 0.5);
        } else {
            Direction dirY;
            Direction direction = dirY = hitLoc.field_72448_b > 0.5 ? Direction.UP : Direction.DOWN;
            Direction dirXZ = faceHit.func_176740_k() == Direction.Axis.X ? (hitLoc.field_72449_c > 0.5 ? Direction.SOUTH : Direction.NORTH) : (hitLoc.field_72450_a > 0.5 ? Direction.EAST : Direction.WEST);
            neighbors[0] = this.field_174879_c.func_177972_a(dirY);
            neighbors[1] = this.field_174879_c.func_177972_a(dirXZ);
            neighbors[2] = neighbors[0].func_177972_a(dirXZ);
            hitVecs[0] = hitLoc.func_72441_c(0.0, (double)dirY.func_96559_d() * 0.5, 0.0);
            hitVecs[1] = hitLoc.func_72441_c((double)dirXZ.func_82601_c() * 0.5, 0.0, (double)dirXZ.func_82599_e() * 0.5);
            hitVecs[2] = hitVecs[0].func_72441_c((double)dirXZ.func_82601_c() * 0.5, 0.0, (double)dirXZ.func_82599_e() * 0.5);
        }
        for (int i = 0; i < 3; ++i) {
            Direction otherFace;
            TileEntity te = this.field_145850_b.func_175625_s(neighbors[i]);
            if (!(te instanceof FramedCollapsibleTileEntity) || (otherFace = ((FramedCollapsibleTileEntity)te).collapsedFace) != null && otherFace != faceHit) continue;
            int vert = FramedCollapsibleTileEntity.vertexFromHit(faceHit, MathUtils.wrapVector(hitVecs[i], 0.0, 1.0));
            ((FramedCollapsibleTileEntity)te).applyDeformation(vert, offset, faceHit);
        }
    }

    private static int vertexFromHit(Direction faceHit, Vector3d loc) {
        double xz;
        if (faceHit.func_176740_k() == Direction.Axis.Y) {
            if (loc.field_72449_c < 0.5 == (faceHit == Direction.UP)) {
                return loc.field_72450_a < 0.5 ? 0 : 3;
            }
            return loc.field_72450_a < 0.5 ? 1 : 2;
        }
        boolean positive = faceHit == Direction.SOUTH || faceHit == Direction.WEST;
        double d = xz = faceHit.func_176740_k() == Direction.Axis.X ? loc.field_72449_c : loc.field_72450_a;
        if (loc.field_72448_b < 0.5) {
            return xz < 0.5 == positive ? 1 : 2;
        }
        return xz < 0.5 == positive ? 0 : 3;
    }

    public byte[] getVertexOffsets() {
        return this.vertexOffsets;
    }

    public int getPackedOffsets() {
        return FramedCollapsibleTileEntity.packOffsets(this.vertexOffsets);
    }

    @Override
    protected void writeToDataPacket(CompoundNBT nbt) {
        super.writeToDataPacket(nbt);
        nbt.func_74768_a("offsets", FramedCollapsibleTileEntity.packOffsets(this.vertexOffsets));
        nbt.func_74768_a("face", this.collapsedFace == null ? -1 : this.collapsedFace.func_176745_a());
    }

    @Override
    protected boolean readFromDataPacket(CompoundNBT nbt) {
        int faceIdx;
        Direction face;
        boolean needUpdate = super.readFromDataPacket(nbt);
        int packed = nbt.func_74762_e("offsets");
        byte[] offsets = FramedCollapsibleTileEntity.unpackOffsets(packed);
        if (!Arrays.equals(offsets, this.vertexOffsets)) {
            this.vertexOffsets = offsets;
            this.getModelData().setData(OFFSETS, (Object)packed);
            needUpdate = true;
        }
        Direction direction = face = (faceIdx = nbt.func_74762_e("face")) == -1 ? null : Direction.func_82600_a((int)faceIdx);
        if (this.collapsedFace != face) {
            this.collapsedFace = face;
            this.getModelData().setData(COLLAPSED_FACE, (Object)this.collapsedFace);
            needUpdate = true;
        }
        return needUpdate;
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_74768_a("offsets", FramedCollapsibleTileEntity.packOffsets(this.vertexOffsets));
        nbt.func_74768_a("face", this.collapsedFace == null ? -1 : this.collapsedFace.func_176745_a());
        return nbt;
    }

    @Override
    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        super.handleUpdateTag(state, nbt);
        int packed = nbt.func_74762_e("offsets");
        this.vertexOffsets = FramedCollapsibleTileEntity.unpackOffsets(packed);
        this.getModelData().setData(OFFSETS, (Object)packed);
        int face = nbt.func_74762_e("face");
        this.collapsedFace = face == -1 ? null : Direction.func_82600_a((int)face);
        this.getModelData().setData(COLLAPSED_FACE, (Object)this.collapsedFace);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_74768_a("offsets", FramedCollapsibleTileEntity.packOffsets(this.vertexOffsets));
        nbt.func_74768_a("face", this.collapsedFace == null ? -1 : this.collapsedFace.func_176745_a());
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.vertexOffsets = FramedCollapsibleTileEntity.unpackOffsets(nbt.func_74762_e("offsets"));
        int face = nbt.func_74762_e("face");
        this.collapsedFace = face == -1 ? null : Direction.func_82600_a((int)face);
    }

    public static int packOffsets(byte[] offsets) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result |= offsets[i] << i * 5;
        }
        return result;
    }

    public static byte[] unpackOffsets(int packed) {
        byte[] offsets = new byte[4];
        for (int i = 0; i < 4; ++i) {
            offsets[i] = (byte)(packed >> i * 5 & 0x1F);
        }
        return offsets;
    }
}

