/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.tileentity;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;
import xfacthd.framedblocks.common.tileentity.FramedDoubleTileEntity;
import xfacthd.framedblocks.common.util.DoubleSoundMode;
import xfacthd.framedblocks.common.util.Utils;

public class FramedDoubleSlopeTileEntity
extends FramedDoubleTileEntity {
    public FramedDoubleSlopeTileEntity() {
        super((TileEntityType)FBContent.tileTypeDoubleFramedSlope.get());
    }

    @Override
    protected boolean hitSecondary(BlockRayTraceResult hit) {
        double hor;
        SlopeType type = (SlopeType)((Object)this.func_195044_w().func_177229_b(PropertyHolder.SLOPE_TYPE));
        Direction facing = (Direction)this.func_195044_w().func_177229_b((Property)PropertyHolder.FACING_HOR);
        Direction side = hit.func_216354_b();
        Vector3d vec = Utils.fraction(hit.func_216347_e());
        if (type == SlopeType.HORIZONTAL) {
            boolean secondary;
            if (side == facing || side == facing.func_176735_f()) {
                return false;
            }
            if (side == facing.func_176734_d() || side == facing.func_176746_e()) {
                return true;
            }
            boolean bl = facing.func_176740_k() == Direction.Axis.X ? vec.func_82615_a() >= vec.func_82616_c() : (secondary = vec.func_82616_c() >= 1.0 - vec.func_82615_a());
            if (facing.func_176743_c() == Direction.AxisDirection.POSITIVE) {
                secondary = !secondary;
            }
            return secondary;
        }
        double d = hor = facing.func_176740_k() == Direction.Axis.X ? vec.func_82615_a() : vec.func_82616_c();
        if (facing.func_176743_c() == Direction.AxisDirection.NEGATIVE) {
            hor = 1.0 - hor;
        }
        if (type == SlopeType.TOP) {
            if (side == facing || side == Direction.UP) {
                return false;
            }
            if (side == facing.func_176734_d() || side == Direction.DOWN) {
                return true;
            }
            return vec.func_82617_b() <= 1.0 - hor;
        }
        if (type == SlopeType.BOTTOM) {
            if (side == facing || side == Direction.DOWN) {
                return false;
            }
            if (side == facing.func_176734_d() || side == Direction.UP) {
                return true;
            }
            return vec.func_82617_b() >= hor;
        }
        return false;
    }

    @Override
    public DoubleSoundMode getSoundMode() {
        SlopeType type = (SlopeType)((Object)this.func_195044_w().func_177229_b(PropertyHolder.SLOPE_TYPE));
        if (type == SlopeType.BOTTOM) {
            return DoubleSoundMode.SECOND;
        }
        if (type == SlopeType.TOP) {
            return DoubleSoundMode.FIRST;
        }
        return DoubleSoundMode.EITHER;
    }

    @Override
    public BlockState getCamoState(Direction side) {
        SlopeType type = (SlopeType)((Object)this.func_195044_w().func_177229_b(PropertyHolder.SLOPE_TYPE));
        Direction facing = (Direction)this.func_195044_w().func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (type == SlopeType.HORIZONTAL) {
            if (side == facing || side == facing.func_176735_f()) {
                return this.getCamoState();
            }
            if (side == facing.func_176734_d() || side == facing.func_176746_e()) {
                return this.getCamoStateTwo();
            }
        } else if (type == SlopeType.TOP) {
            if (side == facing || side == Direction.UP) {
                return this.getCamoState();
            }
            if (side == facing.func_176734_d() || side == Direction.DOWN) {
                return this.getCamoStateTwo();
            }
        } else if (type == SlopeType.BOTTOM) {
            if (side == facing || side == Direction.DOWN) {
                return this.getCamoState();
            }
            if (side == facing.func_176734_d() || side == Direction.UP) {
                return this.getCamoStateTwo();
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    @Override
    public boolean isSolidSide(Direction side) {
        BlockState state = this.getCamoState(side);
        if (!state.func_196958_f()) {
            return state.func_200015_d((IBlockReader)this.field_145850_b, this.field_174879_c);
        }
        return this.getCamoState().func_200015_d((IBlockReader)this.field_145850_b, this.field_174879_c) && this.getCamoStateTwo().func_200015_d((IBlockReader)this.field_145850_b, this.field_174879_c);
    }
}

