/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.adaptiveperformancetweaks.commands.CustomCommand;
import de.markusbordihn.adaptiveperformancetweaks.player.PlayerPosition;
import de.markusbordihn.adaptiveperformancetweaks.player.PlayerPositionManager;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;

public class CommandPlayerPositions
extends CustomCommand {
    private static final CommandPlayerPositions command = new CommandPlayerPositions();

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"playerPositions").requires(cs -> cs.func_197034_c(2))).executes((Command)command);
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Map<String, PlayerPosition> playerPositionMap = PlayerPositionManager.getPlayerPositionMap();
        if (playerPositionMap.isEmpty()) {
            CommandPlayerPositions.sendFeedback(context, "Unable to find any player position!?");
        } else {
            CommandPlayerPositions.sendFeedback(context, String.format("Player Positions (%s online)\n===", playerPositionMap.size()));
            for (Map.Entry<String, PlayerPosition> player : playerPositionMap.entrySet()) {
                String playerName = player.getKey();
                PlayerPosition playerPosition = player.getValue();
                CommandPlayerPositions.sendFeedback(context, String.format("\u221f %s %s", playerName, playerPosition));
            }
        }
        return 0;
    }
}

