/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.adaptiveperformancetweaks.commands.CustomCommand;
import de.markusbordihn.adaptiveperformancetweaks.config.SpawnConfigManager;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;

public class CommandSpecialSpawnRules
extends CustomCommand {
    private static final CommandSpecialSpawnRules command = new CommandSpecialSpawnRules();

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"specialSpawnRules").requires(cs -> cs.func_197034_c(2))).executes((Command)command);
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Map<String, Integer> spawnConfigSpecial = SpawnConfigManager.getSpawnConfigSpecial();
        if (spawnConfigSpecial.isEmpty()) {
            CommandSpecialSpawnRules.sendFeedback(context, "Unable to find any special spawn config!");
            return 0;
        }
        CommandSpecialSpawnRules.sendFeedback(context, "Special Spawn Rules, please check info.log for the full output.\n===");
        CommandSpecialSpawnRules.sendFeedback(context, "World|entityName|perWorld");
        for (Map.Entry<String, Integer> entry : spawnConfigSpecial.entrySet()) {
            String[] worldEntityEntry = entry.getKey().split(":");
            if (worldEntityEntry.length == 4) {
                String entityName = worldEntityEntry[2] + ":" + worldEntityEntry[3];
                String worldName = worldEntityEntry[0] + ":" + worldEntityEntry[1];
                int spawnRatePerWorld = entry.getValue();
                CommandSpecialSpawnRules.sendFeedback(context, String.format("%s|%s|%s", worldName, entityName, spawnRatePerWorld));
                continue;
            }
            log.error("Invalid Special Spawn entry: {}", entry);
        }
        return 0;
    }
}

