/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.config.mods;

import de.markusbordihn.adaptiveperformancetweaks.config.mods.SpawnConfigModSupport;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class MinecraftConfig
extends SpawnConfigModSupport {
    private static final String NAME = "Minecraft";
    private static final String MOD_ID = "minecraft";
    private static Set<String> passiveMobList = new HashSet<String>();
    private static Set<String> neutralMobList = new HashSet<String>();
    private static Set<String> hostileMobList = new HashSet<String>();
    private static Set<String> passiveWaterMobList = new HashSet<String>();
    private static Set<String> neutralWaterMobList = new HashSet<String>();
    private static Map<String, Integer> specialMobList = new HashMap<String, Integer>();

    public static void addSpawnRates() {
        if (Boolean.FALSE.equals(MinecraftConfig.COMMON.minecraftEnabled.get()) || MOD_ID.isEmpty()) {
            return;
        }
        MinecraftConfig.addSpecialSpawnRates(NAME, specialMobList);
        for (ResourceLocation registryName : ForgeRegistries.ENTITIES.getKeys()) {
            if (!registryName.toString().startsWith("minecraft:")) continue;
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(registryName);
            EntityClassification entityClassification = entityType.func_220339_d();
            if (entityClassification == EntityClassification.AMBIENT) {
                passiveMobList.add(registryName.toString());
                continue;
            }
            if (entityClassification == EntityClassification.CREATURE) {
                neutralMobList.add(registryName.toString());
                continue;
            }
            if (entityClassification == EntityClassification.MONSTER) {
                hostileMobList.add(registryName.toString());
                continue;
            }
            if (entityClassification == EntityClassification.WATER_AMBIENT) {
                passiveWaterMobList.add(registryName.toString());
                continue;
            }
            if (entityClassification != EntityClassification.WATER_CREATURE) continue;
            neutralWaterMobList.add(registryName.toString());
        }
        MinecraftConfig.addSpawnRatesForPassiveMobs(NAME, passiveMobList, (Integer)MinecraftConfig.COMMON.minecraftMaxPassiveMobsPerPlayer.get(), (Integer)MinecraftConfig.COMMON.minecraftMaxPassiveMobsPerWorld.get());
        MinecraftConfig.addSpawnRatesForNeutralMobs(NAME, neutralMobList, (Integer)MinecraftConfig.COMMON.minecraftMaxNeutralMobsPerPlayer.get(), (Integer)MinecraftConfig.COMMON.minecraftMaxNeutralMobsPerWorld.get());
        MinecraftConfig.addSpawnRatesForHostileMobs(NAME, hostileMobList, (Integer)MinecraftConfig.COMMON.minecraftMaxHostileMobsPerPlayer.get(), (Integer)MinecraftConfig.COMMON.minecraftMaxHostileMobsPerWorld.get());
        MinecraftConfig.addSpawnRatesForPassiveMobs("Minecraft (water)", passiveWaterMobList, (Integer)MinecraftConfig.COMMON.minecraftMaxWaterPassiveMobsPerPlayer.get(), (Integer)MinecraftConfig.COMMON.minecraftMaxWaterPassiveMobsPerWorld.get());
        MinecraftConfig.addSpawnRatesForNeutralMobs("Minecraft (water)", neutralWaterMobList, (Integer)MinecraftConfig.COMMON.minecraftMaxWaterNeutralMobsPerPlayer.get(), (Integer)MinecraftConfig.COMMON.minecraftMaxWaterNeutralMobsPerWorld.get());
    }

    static {
        specialMobList.put("minecraft:the_end:minecraft:enderman", 40);
        specialMobList.put("minecraft:the_nether:minecraft:piglin", 20);
        specialMobList.put("minecraft:the_nether:minecraft:piglin_brute", 20);
        specialMobList.put("minecraft:the_nether:minecraft:skeleton", 20);
        specialMobList.put("minecraft:the_nether:minecraft:wither_skeleton", 10);
        specialMobList.put("minecraft:the_nether:minecraft:zombified_piglin", 20);
    }
}

