/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.debug;

import de.markusbordihn.adaptiveperformancetweaks.Manager;
import de.markusbordihn.adaptiveperformancetweaks.config.CommonConfig;
import de.markusbordihn.adaptiveperformancetweaks.entity.EntityManager;
import de.markusbordihn.adaptiveperformancetweaks.entity.ExperienceOrbEntityManager;
import de.markusbordihn.adaptiveperformancetweaks.entity.ItemEntityManager;
import de.markusbordihn.adaptiveperformancetweaks.entity.MonsterEntityManager;
import de.markusbordihn.adaptiveperformancetweaks.player.PlayerManager;
import de.markusbordihn.adaptiveperformancetweaks.player.PlayerPositionManager;
import de.markusbordihn.adaptiveperformancetweaks.spawn.SpawnManager;
import de.markusbordihn.adaptiveperformancetweaks.spawn.SpawnerManager;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DebugManager
extends Manager {
    private static final String LOG_NAME = DebugManager.class.getSimpleName();
    private static final Logger log = DebugManager.getLogger(LOG_NAME);
    private static Level logLevel = Level.INFO;

    @SubscribeEvent
    public static void handleModConfigLoadEvent(ModConfig.Loading event) {
        DebugManager.adjustLogLevel((String)CommonConfig.COMMON.logLevel.get());
    }

    public static void adjustLogLevel(String logLevel) {
        log.info("Try to change log level to {}", (Object)logLevel);
        Level newLogLevel = Level.INFO;
        switch (logLevel) {
            case "info": {
                break;
            }
            case "trace": {
                newLogLevel = Level.TRACE;
                break;
            }
            case "debug": {
                newLogLevel = Level.DEBUG;
                break;
            }
            case "warn": {
                newLogLevel = Level.WARN;
                break;
            }
            case "error": {
                newLogLevel = Level.ERROR;
                break;
            }
            case "fatal": {
                newLogLevel = Level.FATAL;
                break;
            }
            default: {
                log.error("Got invalid log level {} from config file!", CommonConfig.COMMON.logLevel.get());
            }
        }
        Configurator.setAllLevels((String)LogManager.getLogger((String)"APTweaks").getName(), (Level)newLogLevel);
        Configurator.setAllLevels((String)LogManager.getLogger((String)DebugManager.getLoggerName(EntityManager.LOG_NAME)).getName(), (Level)newLogLevel);
        Configurator.setAllLevels((String)LogManager.getLogger((String)DebugManager.getLoggerName(ExperienceOrbEntityManager.LOG_NAME)).getName(), (Level)newLogLevel);
        Configurator.setAllLevels((String)LogManager.getLogger((String)DebugManager.getLoggerName(ItemEntityManager.LOG_NAME)).getName(), (Level)newLogLevel);
        Configurator.setAllLevels((String)LogManager.getLogger((String)DebugManager.getLoggerName(MonsterEntityManager.LOG_NAME)).getName(), (Level)newLogLevel);
        Configurator.setAllLevels((String)LogManager.getLogger((String)DebugManager.getLoggerName(PlayerManager.LOG_NAME)).getName(), (Level)newLogLevel);
        Configurator.setAllLevels((String)LogManager.getLogger((String)DebugManager.getLoggerName(PlayerPositionManager.LOG_NAME)).getName(), (Level)newLogLevel);
        Configurator.setAllLevels((String)LogManager.getLogger((String)DebugManager.getLoggerName(SpawnManager.LOG_NAME)).getName(), (Level)newLogLevel);
        Configurator.setAllLevels((String)LogManager.getLogger((String)DebugManager.getLoggerName(SpawnerManager.LOG_NAME)).getName(), (Level)newLogLevel);
        log.info("Change log level from {} to {}", (Object)DebugManager.logLevel, (Object)newLogLevel);
        DebugManager.logLevel = newLogLevel;
    }
}

