/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.entity;

import de.markusbordihn.adaptiveperformancetweaks.Manager;
import de.markusbordihn.adaptiveperformancetweaks.server.ServerLoadEvent;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class MonsterEntityManager
extends Manager {
    private static Map<String, Set<MonsterEntity>> monsterEntityMap = new ConcurrentHashMap<String, Set<MonsterEntity>>();
    private static boolean burnCreeperDuringDaylight = (Boolean)MonsterEntityManager.COMMON.burnCreeperDuringDaylight.get();
    private static boolean modDungeonsmodOptimizeWhirlwind = (Boolean)MonsterEntityManager.COMMON.modDungeonsmodOptimizeWhirlwind.get();
    private static boolean runCleanup = false;
    public static final String LOG_NAME = MonsterEntityManager.class.getSimpleName();
    private static final Logger log = MonsterEntityManager.getLogger(LOG_NAME);

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
        monsterEntityMap = new ConcurrentHashMap<String, Set<MonsterEntity>>();
        burnCreeperDuringDaylight = (Boolean)MonsterEntityManager.COMMON.burnCreeperDuringDaylight.get();
        modDungeonsmodOptimizeWhirlwind = (Boolean)MonsterEntityManager.COMMON.modDungeonsmodOptimizeWhirlwind.get();
        runCleanup = burnCreeperDuringDaylight || modDungeonsmodOptimizeWhirlwind;
    }

    @SubscribeEvent
    public static void handleServerLoadEvent(ServerLoadEvent event) {
        if (event.hasHighServerLoad()) {
            MonsterEntityManager.cleanupMonster();
        }
    }

    public static void handleMonsterEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        MonsterEntity monsterEntity = (MonsterEntity)event.getEntity();
        String monsterName = monsterEntity.func_70022_Q();
        String monsterDisplayName = monsterEntity.func_145748_c_().getString();
        String worldName = monsterEntity.field_70170_p.func_234923_W_().func_240901_a_().toString();
        String monsterEntityMapKey = '[' + worldName + ']' + monsterName;
        monsterEntityMap.computeIfAbsent(monsterEntityMapKey, k -> new LinkedHashSet());
        Set<MonsterEntity> monsterEntities = monsterEntityMap.get(monsterEntityMapKey);
        monsterEntities.add(monsterEntity);
        log.debug("Monster {} {} joined {}.", (Object)monsterName, (Object)monsterDisplayName, (Object)worldName);
    }

    public static void handleMonsterEntityLeaveWorldEvent(EntityLeaveWorldEvent event) {
        MonsterEntity monsterEntity = (MonsterEntity)event.getEntity();
        String monsterName = monsterEntity.func_70022_Q();
        String monsterDisplayName = monsterEntity.func_145748_c_().getString();
        String worldName = monsterEntity.field_70170_p.func_234923_W_().func_240901_a_().toString();
        Set<MonsterEntity> monsterEntities = monsterEntityMap.get('[' + worldName + ']' + monsterName);
        if (monsterEntities != null) {
            monsterEntities.remove(monsterEntity);
            log.debug("Monster {} {} leaved {}.", (Object)monsterName, (Object)monsterDisplayName, (Object)worldName);
        } else {
            log.warn("Monster {} {} in {} was not tracked by monster entity manager!", (Object)monsterName, (Object)monsterDisplayName, (Object)worldName);
        }
    }

    public static void cleanupMonster() {
        if (!runCleanup) {
            return;
        }
        for (Map.Entry<String, Set<MonsterEntity>> monsterEntities : monsterEntityMap.entrySet()) {
            for (MonsterEntity monsterEntity : monsterEntities.getValue()) {
                World entityWorld = monsterEntity.field_70170_p;
                String monsterName = monsterEntity.func_70022_Q();
                if (!entityWorld.func_72935_r()) continue;
                if (burnCreeperDuringDaylight && monsterEntity instanceof CreeperEntity && entityWorld.func_226660_f_(monsterEntity.func_233580_cy_())) {
                    CreeperEntity creeperEntity = (CreeperEntity)monsterEntity;
                    creeperEntity.func_146079_cb();
                }
                if (!modDungeonsmodOptimizeWhirlwind || !"dungeonsmod:whirlwind".equals(monsterName)) continue;
                monsterEntity.func_70106_y();
            }
        }
    }

    public static Map<String, Set<MonsterEntity>> getMonsterEntityMap() {
        return monsterEntityMap;
    }
}

