/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.gamerules;

import de.markusbordihn.adaptiveperformancetweaks.Manager;
import de.markusbordihn.adaptiveperformancetweaks.commands.CommandManager;
import de.markusbordihn.adaptiveperformancetweaks.server.ServerLoadEvent;
import net.minecraft.world.GameRules;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class GameRuleManager
extends Manager {
    private static GameRules gameRules;
    private static boolean entityCrammingEnabled;
    private static boolean gameruleEnabled;
    private static boolean randomTickSpeedEnabled;
    private static int maxEntityCramming;
    private static int minEntityCramming;
    private static int minEntityCrammingMineColonies;
    private static int randomTickSpeed;
    private static final Logger log;

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
        entityCrammingEnabled = (Boolean)GameRuleManager.COMMON.entityCrammingEnabled.get();
        gameruleEnabled = (Boolean)GameRuleManager.COMMON.gameruleEnabled.get();
        maxEntityCramming = (Integer)GameRuleManager.COMMON.maxEntityCramming.get();
        minEntityCramming = (Integer)GameRuleManager.COMMON.minEntityCramming.get();
        randomTickSpeed = (Integer)GameRuleManager.COMMON.randomTickSpeed.get();
        randomTickSpeedEnabled = (Boolean)GameRuleManager.COMMON.randomTickSpeedEnabled.get();
        if (minEntityCramming >= maxEntityCramming) {
            minEntityCramming = maxEntityCramming - 1;
        }
        if (entityCrammingEnabled && ModList.get().isLoaded("minecolonies") && minEntityCramming < minEntityCrammingMineColonies) {
            log.warn("WARNING: The recommended value for minEntityCramming with {} is min. {} instead of {}!", (Object)"MineColonies", (Object)minEntityCrammingMineColonies, (Object)minEntityCramming);
            log.info("The minEntityCramming will be automatically set to {}!", (Object)minEntityCrammingMineColonies);
            minEntityCramming = minEntityCrammingMineColonies;
            if (maxEntityCramming <= minEntityCramming) {
                maxEntityCramming = minEntityCramming + 1;
            }
        }
    }

    @SubscribeEvent
    public static void handleServerStartingEvent(FMLServerStartingEvent event) {
        gameRules = ServerLifecycleHooks.getCurrentServer().func_200252_aR();
        if (!gameruleEnabled) {
            return;
        }
        if (randomTickSpeedEnabled) {
            log.info("Random Tick Speed will be optimized between {} and {}", (Object)1, (Object)randomTickSpeed);
            if (gameRules.func_223592_c(GameRules.field_223610_m) != randomTickSpeed) {
                GameRuleManager.setRandomTickSpeed(randomTickSpeed);
            }
        }
        if (entityCrammingEnabled) {
            log.info("Max Entity Cramming will be optimized between {} and {}", (Object)minEntityCramming, (Object)maxEntityCramming);
            if (gameRules.func_223592_c(GameRules.field_223616_s) != maxEntityCramming) {
                GameRuleManager.setMaxEntityCramming(maxEntityCramming);
            }
        }
    }

    @SubscribeEvent
    public static void handleServerLoadEvent(ServerLoadEvent event) {
        if (!gameruleEnabled) {
            return;
        }
        gameRules = ServerLifecycleHooks.getCurrentServer().func_200252_aR();
        if (event.hasVeryHighServerLoad()) {
            if (entityCrammingEnabled) {
                GameRuleManager.decreaseMaxEntityCramming();
            }
            if (randomTickSpeedEnabled) {
                GameRuleManager.decreaseRandomTickSpeed();
            }
        } else if (event.hasHighServerLoad()) {
            if (randomTickSpeedEnabled) {
                GameRuleManager.decreaseRandomTickSpeed();
            }
        } else if (event.hasLowServerLoad()) {
            if (randomTickSpeedEnabled) {
                GameRuleManager.increaseRandomTickSpeed();
            }
            if (entityCrammingEnabled) {
                GameRuleManager.increaseMaxEntityCramming();
            }
        }
    }

    public static void decreaseRandomTickSpeed() {
        GameRuleManager.setRandomTickSpeed(gameRules.func_223592_c(GameRules.field_223610_m) - 1);
    }

    public static void increaseRandomTickSpeed() {
        GameRuleManager.setRandomTickSpeed(gameRules.func_223592_c(GameRules.field_223610_m) + 1);
    }

    public static void setRandomTickSpeed(int tickSpeed) {
        int currentTickSpeed = gameRules.func_223592_c(GameRules.field_223610_m);
        if (tickSpeed < 1) {
            tickSpeed = 1;
        } else if (tickSpeed > randomTickSpeed) {
            tickSpeed = randomTickSpeed;
        }
        if (currentTickSpeed != tickSpeed) {
            log.debug("Changing randomTickSpeed from {} to {}", (Object)currentTickSpeed, (Object)tickSpeed);
            CommandManager.executeServerCommand(String.format("gamerule randomTickSpeed %s", tickSpeed));
        }
    }

    public static void decreaseMaxEntityCramming() {
        GameRuleManager.setMaxEntityCramming(gameRules.func_223592_c(GameRules.field_223616_s) - 1);
    }

    public static void increaseMaxEntityCramming() {
        GameRuleManager.setMaxEntityCramming(gameRules.func_223592_c(GameRules.field_223616_s) + 1);
    }

    public static void setMaxEntityCramming(int maxEntity) {
        if (maxEntity < minEntityCramming) {
            maxEntity = minEntityCramming;
        } else if (maxEntity > maxEntityCramming) {
            maxEntity = maxEntityCramming;
        }
        int currentMaxEntityCramming = gameRules.func_223592_c(GameRules.field_223616_s);
        if (currentMaxEntityCramming != maxEntity) {
            log.debug("Changing maxEntityCramming from {} to {}", (Object)currentMaxEntityCramming, (Object)maxEntity);
            CommandManager.executeServerCommand(String.format("gamerule maxEntityCramming %s", maxEntity));
        }
    }

    static {
        entityCrammingEnabled = (Boolean)GameRuleManager.COMMON.entityCrammingEnabled.get();
        gameruleEnabled = (Boolean)GameRuleManager.COMMON.gameruleEnabled.get();
        randomTickSpeedEnabled = (Boolean)GameRuleManager.COMMON.randomTickSpeedEnabled.get();
        maxEntityCramming = (Integer)GameRuleManager.COMMON.maxEntityCramming.get();
        minEntityCramming = (Integer)GameRuleManager.COMMON.maxEntityCramming.get();
        minEntityCrammingMineColonies = 16;
        randomTickSpeed = (Integer)GameRuleManager.COMMON.randomTickSpeed.get();
        log = GameRuleManager.getLogger(GameRuleManager.class.getSimpleName());
    }
}

