/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.player;

import de.markusbordihn.adaptiveperformancetweaks.Optimization;
import de.markusbordihn.adaptiveperformancetweaks.gamerules.GameRuleManager;
import de.markusbordihn.adaptiveperformancetweaks.player.PlayerManager;
import de.markusbordihn.adaptiveperformancetweaks.server.ServerLoad;
import de.markusbordihn.adaptiveperformancetweaks.world.WorldViewManager;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class PlayerOptimization
extends Optimization {
    @SubscribeEvent
    public static void handlePlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        String username = event.getPlayer().func_200200_C_().getString();
        if (!username.isEmpty() && Boolean.TRUE.equals(PlayerOptimization.COMMON.optimizePlayerLogin.get())) {
            ServerPlayerEntity player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152612_a(username);
            log.debug("Optimize Player Login for {} {}", (Object)username, (Object)player);
            if (PlayerManager.getNumberOfPlayers() == 0 && (ServerLoad.hasLowServerLoad() || ServerLoad.hasNormalServerLoad())) {
                WorldViewManager.setAvgViewDistance(player.func_71121_q());
            } else {
                if (Boolean.TRUE.equals(PlayerOptimization.COMMON.optimizeViewDistance.get())) {
                    WorldViewManager.decreaseViewDistance(player.func_71121_q());
                }
                if (Boolean.TRUE.equals(PlayerOptimization.COMMON.gameruleEnabled.get())) {
                    if (Boolean.TRUE.equals(PlayerOptimization.COMMON.randomTickSpeedEnabled.get())) {
                        GameRuleManager.decreaseRandomTickSpeed();
                    }
                    if (Boolean.TRUE.equals(PlayerOptimization.COMMON.entityCrammingEnabled.get())) {
                        GameRuleManager.decreaseMaxEntityCramming();
                    }
                }
            }
        }
    }
}

