/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.server;

import de.markusbordihn.adaptiveperformancetweaks.config.CommonConfig;
import de.markusbordihn.adaptiveperformancetweaks.server.ServerLoadEvent;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class ServerLoad {
    public static final Logger log = LogManager.getLogger((String)"APTweaks");
    private static ServerLoadLevel currentServerLoad = ServerLoadLevel.NORMAL;
    private static ServerLoadLevel lastServerLoad = ServerLoadLevel.NORMAL;
    private static boolean logServerLoad = (Boolean)CommonConfig.COMMON.logServerLoad.get();
    private static double avgTickTime;

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
        logServerLoad = (Boolean)CommonConfig.COMMON.logServerLoad.get();
    }

    public static void measureLoadAndPost() {
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer == null) {
            return;
        }
        avgTickTime = currentServer.func_211149_aT();
        lastServerLoad = currentServerLoad;
        currentServerLoad = ServerLoad.getServerLoadLevelFromTickTime(avgTickTime);
        if (currentServerLoad != lastServerLoad && logServerLoad) {
            log.info("Server load changed from {} to {} (avg. {})", (Object)lastServerLoad, (Object)currentServerLoad, (Object)avgTickTime);
        }
        MinecraftForge.EVENT_BUS.post((Event)new ServerLoadEvent(currentServerLoad, lastServerLoad));
    }

    public static ServerLoadLevel getServerLoadLevelFromTickTime(double tickTime) {
        if (tickTime <= 20.0) {
            return ServerLoadLevel.VERY_LOW;
        }
        if (tickTime <= 40.0) {
            return ServerLoadLevel.LOW;
        }
        if (tickTime <= 46.0) {
            return ServerLoadLevel.NORMAL;
        }
        if (tickTime <= 49.0) {
            return ServerLoadLevel.MEDIUM;
        }
        if (tickTime <= 55.0) {
            return ServerLoadLevel.HIGH;
        }
        if (tickTime > 55.0) {
            return ServerLoadLevel.VERY_HIGH;
        }
        return ServerLoadLevel.NORMAL;
    }

    public static ServerLoadLevel getServerLoad() {
        return currentServerLoad;
    }

    public static ServerLoadLevel getLastServerLoad() {
        return lastServerLoad;
    }

    public static boolean hasVeryHighServerLoad() {
        return currentServerLoad == ServerLoadLevel.VERY_HIGH;
    }

    public static boolean hasHighServerLoad() {
        return currentServerLoad == ServerLoadLevel.MEDIUM || currentServerLoad == ServerLoadLevel.HIGH || currentServerLoad == ServerLoadLevel.VERY_HIGH;
    }

    public static boolean hasNormalServerLoad() {
        return currentServerLoad == ServerLoadLevel.NORMAL;
    }

    public static boolean hasLowServerLoad() {
        return currentServerLoad == ServerLoadLevel.VERY_LOW || currentServerLoad == ServerLoadLevel.LOW;
    }

    public static double getAvgTickTime() {
        return avgTickTime;
    }

    public static enum ServerLoadLevel {
        VERY_LOW,
        LOW,
        NORMAL,
        MEDIUM,
        HIGH,
        VERY_HIGH;

    }
}

