/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.server;

import de.markusbordihn.adaptiveperformancetweaks.config.CommonConfig;
import de.markusbordihn.adaptiveperformancetweaks.server.ServerWorldLoadEvent;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class ServerWorldLoad {
    public static final Logger log = LogManager.getLogger((String)"APTweaks");
    private static boolean logServerLoad = (Boolean)CommonConfig.COMMON.logServerLoad.get();
    private static Map<ServerWorld, Double> worldLoad = new ConcurrentHashMap<ServerWorld, Double>();
    private static Map<ServerWorld, ServerWorldLoadLevel> lastWorldLoadLevel = new ConcurrentHashMap<ServerWorld, ServerWorldLoadLevel>();
    private static Map<ServerWorld, ServerWorldLoadLevel> worldLoadLevel = new ConcurrentHashMap<ServerWorld, ServerWorldLoadLevel>();

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
        worldLoad = new ConcurrentHashMap<ServerWorld, Double>();
        lastWorldLoadLevel = new ConcurrentHashMap<ServerWorld, ServerWorldLoadLevel>();
        worldLoadLevel = new ConcurrentHashMap<ServerWorld, ServerWorldLoadLevel>();
        logServerLoad = (Boolean)CommonConfig.COMMON.logServerLoad.get();
    }

    public static void measureLoadAndPost() {
        MinecraftServer minecraftServer = ServerLifecycleHooks.getCurrentServer();
        Iterable serverWorlds = minecraftServer.func_212370_w();
        for (ServerWorld serverWorld : serverWorlds) {
            long[] tickTimes = minecraftServer.getTickTime(serverWorld.func_234923_W_());
            if (tickTimes == null) {
                return;
            }
            double avgTickTime = Arrays.stream(tickTimes).average().orElse(Double.NaN) / 1000000.0;
            ServerWorldLoadLevel loadLevel = ServerWorldLoad.getServerWorldLoadLevelFromTickTime(avgTickTime);
            ServerWorldLoadLevel lastLoadLevel = worldLoadLevel.getOrDefault(serverWorld, ServerWorldLoadLevel.NORMAL);
            lastWorldLoadLevel.put(serverWorld, lastLoadLevel);
            worldLoad.put(serverWorld, avgTickTime);
            worldLoadLevel.put(serverWorld, loadLevel);
            if (loadLevel != lastLoadLevel && logServerLoad) {
                log.info("World load for {} changed from {} to {} (avg. {})", (Object)serverWorld.func_234923_W_().func_240901_a_(), (Object)lastLoadLevel, (Object)loadLevel, (Object)avgTickTime);
            }
            MinecraftForge.EVENT_BUS.post((Event)new ServerWorldLoadEvent(serverWorld, loadLevel, lastLoadLevel));
        }
    }

    public static ServerWorldLoadLevel getServerWorldLoadLevelFromTickTime(double tickTime) {
        if (tickTime <= 15.0) {
            return ServerWorldLoadLevel.VERY_LOW;
        }
        if (tickTime <= 35.0) {
            return ServerWorldLoadLevel.LOW;
        }
        if (tickTime <= 41.0) {
            return ServerWorldLoadLevel.NORMAL;
        }
        if (tickTime <= 46.0) {
            return ServerWorldLoadLevel.MEDIUM;
        }
        if (tickTime <= 50.0) {
            return ServerWorldLoadLevel.HIGH;
        }
        if (tickTime > 50.0) {
            return ServerWorldLoadLevel.VERY_HIGH;
        }
        return ServerWorldLoadLevel.NORMAL;
    }

    public static Map<ServerWorld, Double> getWorldLoad() {
        return worldLoad;
    }

    public static Map<ServerWorld, ServerWorldLoadLevel> getWorldLoadLevel() {
        return worldLoadLevel;
    }

    public static enum ServerWorldLoadLevel {
        VERY_LOW,
        LOW,
        NORMAL,
        MEDIUM,
        HIGH,
        VERY_HIGH;

    }
}

