/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.world;

import de.markusbordihn.adaptiveperformancetweaks.Optimization;
import de.markusbordihn.adaptiveperformancetweaks.player.PlayerManager;
import de.markusbordihn.adaptiveperformancetweaks.server.ServerLoad;
import de.markusbordihn.adaptiveperformancetweaks.server.ServerWorldLoadEvent;
import de.markusbordihn.adaptiveperformancetweaks.world.WorldViewManager;
import java.util.List;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class WorldOptimization
extends Optimization {
    public static final int VIEW_DISTANCE_EMPTY_WORLD = 3;

    @SubscribeEvent
    public static void handleServerWorldLoadEvent(ServerWorldLoadEvent event) {
        ServerWorld serverWorld = event.getServerWorld();
        List players = serverWorld.func_217369_A();
        if (Boolean.FALSE.equals(WorldOptimization.COMMON.optimizeViewDistance.get())) {
            return;
        }
        if (players.isEmpty()) {
            WorldViewManager.setViewDistance(serverWorld, 3);
            return;
        }
        if (ServerLoad.hasHighServerLoad() && event.hasHighServerWorldLoad()) {
            WorldViewManager.decreaseViewDistance(serverWorld);
        } else if (ServerLoad.hasVeryHighServerLoad() && event.hasNormalServerWorldLoad()) {
            WorldViewManager.decreaseViewDistance(serverWorld);
        } else if (ServerLoad.hasNormalServerLoad() && event.hasLowServerWorldLoad() && PlayerManager.getNumberOfPlayers() == 1) {
            WorldViewManager.increaseViewDistance(serverWorld);
        } else if (ServerLoad.hasLowServerLoad() && event.hasLowServerWorldLoad() && PlayerManager.getNumberOfPlayers() > 0) {
            WorldViewManager.increaseViewDistance(serverWorld);
        }
    }
}

