/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.event;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import tschipp.carryon.client.helper.CarryRenderHelper;
import tschipp.carryon.common.handler.RegistrationHandler;
import tschipp.carryon.common.item.ItemCarryonEntity;
import tschipp.carryon.common.scripting.CarryOnOverride;
import tschipp.carryon.common.scripting.ScriptChecker;

public class RenderEntityEvents {
    public static final Map<String, Entity> nbtEntityMap = new HashMap<String, Entity>();

    public static Entity getEntity(ItemStack carried, World world) {
        String nbt = ItemCarryonEntity.getPersistentData(carried).toString();
        if (nbtEntityMap.containsKey(nbt)) {
            return nbtEntityMap.get(nbt);
        }
        Entity entity = ItemCarryonEntity.getEntity(carried, world);
        nbtEntityMap.put(nbt, entity);
        return entity;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        nbtEntityMap.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderHand(RenderHandEvent event) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = player.func_184614_ca();
        int perspective = CarryRenderHelper.getPerspective();
        float partialticks = event.getPartialTicks();
        MatrixStack matrix = event.getMatrixStack();
        int light = event.getLight();
        IRenderTypeBuffer buffer = event.getBuffers();
        EntityRendererManager manager = Minecraft.func_71410_x().func_175598_ae();
        if (!stack.func_190926_b() && stack.func_77973_b() == RegistrationHandler.itemEntity && ItemCarryonEntity.hasEntityData(stack)) {
            if (ModList.get().isLoaded("realrender") || ModList.get().isLoaded("rfpr")) {
                return;
            }
            Entity entity = RenderEntityEvents.getEntity(stack, (World)world);
            if (entity != null) {
                Vector3d playerpos = CarryRenderHelper.getExactPos((Entity)player, partialticks);
                entity.func_70107_b(playerpos.field_72450_a, playerpos.field_72448_b, playerpos.field_72449_c);
                entity.field_70177_z = 0.0f;
                entity.field_70126_B = 0.0f;
                entity.func_70034_d(0.0f);
                float height = entity.func_213302_cg();
                float width = entity.func_213311_cf();
                matrix.func_227860_a_();
                matrix.func_227862_a_(0.8f, 0.8f, 0.8f);
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                matrix.func_227861_a_(0.0, (double)(-height) - 0.1, (double)width + 0.1);
                RenderSystem.enableAlphaTest();
                if (perspective == 0) {
                    RenderHelper.func_227780_a_();
                    manager.func_178633_a(false);
                    CarryOnOverride carryOverride = ScriptChecker.getOverride((PlayerEntity)player);
                    if (carryOverride != null) {
                        CarryRenderHelper.performOverrideTransformation(matrix, carryOverride);
                        String entityname = carryOverride.getRenderNameEntity();
                        if (entityname != null) {
                            Entity newEntity = null;
                            Optional type = EntityType.func_220327_a((String)entityname);
                            if (type.isPresent()) {
                                newEntity = ((EntityType)type.get()).func_200721_a((World)world);
                            }
                            if (newEntity != null) {
                                CompoundNBT nbttag = carryOverride.getRenderNBT();
                                if (nbttag != null) {
                                    newEntity.deserializeNBT(nbttag);
                                }
                                entity = newEntity;
                                entity.func_70107_b(playerpos.field_72450_a, playerpos.field_72448_b, playerpos.field_72449_c);
                                entity.field_70177_z = 0.0f;
                                entity.field_70126_B = 0.0f;
                                entity.func_70034_d(0.0f);
                            }
                        }
                    }
                    if (entity instanceof LivingEntity) {
                        ((LivingEntity)entity).field_70737_aN = 0;
                    }
                    manager.func_229084_a_(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrix, buffer, light);
                    manager.func_178633_a(true);
                }
                RenderSystem.disableAlphaTest();
                matrix.func_227865_b_();
                RenderHelper.func_74518_a();
                RenderSystem.disableRescaleNormal();
                if (perspective == 0) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

