/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.PacketDistributor;
import tschipp.carryon.CarryOn;
import tschipp.carryon.common.handler.CustomPickupOverrideHandler;
import tschipp.carryon.common.handler.ModelOverridesHandler;
import tschipp.carryon.common.handler.RegistrationHandler;
import tschipp.carryon.common.item.ItemCarryonBlock;
import tschipp.carryon.common.item.ItemCarryonEntity;
import tschipp.carryon.network.client.CarrySlotPacket;

public class CommandCarryOn {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"carryon").then(Commands.func_197057_a((String)"debug").executes(cmd -> CommandCarryOn.handleDebug((CommandSource)cmd.getSource())))).then(Commands.func_197057_a((String)"clear").executes(cmd -> CommandCarryOn.handleClear((CommandSource)cmd.getSource(), Collections.singleton(((CommandSource)cmd.getSource()).func_197035_h()))))).then(Commands.func_197057_a((String)"clear").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197094_d()).requires(src -> src.func_197034_c(2))).executes(cmd -> CommandCarryOn.handleClear((CommandSource)cmd.getSource(), EntityArgument.func_197090_e((CommandContext)cmd, (String)"target")))));
        dispatcher.register(builder);
    }

    private static int handleDebug(CommandSource source) {
        try {
            if (source.func_197027_g() != null) {
                ServerPlayerEntity player = source.func_197035_h();
                ItemStack main = player.func_184614_ca();
                if (!main.func_190926_b() && main.func_77973_b() == RegistrationHandler.itemTile) {
                    source.func_197030_a((ITextComponent)new StringTextComponent("Block: " + ItemCarryonBlock.getBlock(main)), true);
                    source.func_197030_a((ITextComponent)new StringTextComponent("BlockState: " + ItemCarryonBlock.getBlockState(main)), true);
                    source.func_197030_a((ITextComponent)new StringTextComponent("ItemStack: " + ItemCarryonBlock.getItemStack(main)), true);
                    if (ModelOverridesHandler.hasCustomOverrideModel(ItemCarryonBlock.getBlockState(main), ItemCarryonBlock.getTileData(main))) {
                        source.func_197030_a((ITextComponent)new StringTextComponent("Override Model: " + ModelOverridesHandler.getOverrideObject(ItemCarryonBlock.getBlockState(main), ItemCarryonBlock.getTileData(main))), true);
                    }
                    if (CustomPickupOverrideHandler.hasSpecialPickupConditions(ItemCarryonBlock.getBlockState(main))) {
                        source.func_197030_a((ITextComponent)new StringTextComponent("Custom Pickup Condition: " + CustomPickupOverrideHandler.getPickupCondition(ItemCarryonBlock.getBlockState(main))), true);
                    }
                    CarryOn.LOGGER.info("Block: " + ItemCarryonBlock.getBlock(main));
                    CarryOn.LOGGER.info("BlockState: " + ItemCarryonBlock.getBlockState(main));
                    CarryOn.LOGGER.info("ItemStack: " + ItemCarryonBlock.getItemStack(main));
                    if (ModelOverridesHandler.hasCustomOverrideModel(ItemCarryonBlock.getBlockState(main), ItemCarryonBlock.getTileData(main))) {
                        CarryOn.LOGGER.info("Override Model: " + ModelOverridesHandler.getOverrideObject(ItemCarryonBlock.getBlockState(main), ItemCarryonBlock.getTileData(main)));
                    }
                    if (CustomPickupOverrideHandler.hasSpecialPickupConditions(ItemCarryonBlock.getBlockState(main))) {
                        CarryOn.LOGGER.info("Custom Pickup Condition: " + CustomPickupOverrideHandler.getPickupCondition(ItemCarryonBlock.getBlockState(main)));
                    }
                    return 1;
                }
                if (!main.func_190926_b() && main.func_77973_b() == RegistrationHandler.itemEntity) {
                    source.func_197030_a((ITextComponent)new StringTextComponent("Entity: " + ItemCarryonEntity.getEntity(main, player.field_70170_p)), true);
                    source.func_197030_a((ITextComponent)new StringTextComponent("Entity Name: " + ItemCarryonEntity.getEntityName(main)), true);
                    if (CustomPickupOverrideHandler.hasSpecialPickupConditions(ItemCarryonEntity.getEntity(main, player.field_70170_p))) {
                        source.func_197030_a((ITextComponent)new StringTextComponent("Custom Pickup Condition: " + CustomPickupOverrideHandler.getPickupCondition(ItemCarryonEntity.getEntity(main, player.field_70170_p))), true);
                    }
                    CarryOn.LOGGER.info("Entity: " + ItemCarryonEntity.getEntity(main, player.field_70170_p));
                    CarryOn.LOGGER.info("Entity Name: " + ItemCarryonEntity.getEntityName(main));
                    if (CustomPickupOverrideHandler.hasSpecialPickupConditions(ItemCarryonEntity.getEntity(main, player.field_70170_p))) {
                        CarryOn.LOGGER.info("Custom Pickup Condition: " + CustomPickupOverrideHandler.getPickupCondition(ItemCarryonEntity.getEntity(main, player.field_70170_p)));
                    }
                    return 1;
                }
            }
        }
        catch (CommandSyntaxException e) {
            return 0;
        }
        return 0;
    }

    private static int handleClear(CommandSource source, Collection<ServerPlayerEntity> players) {
        Iterator<ServerPlayerEntity> iterator = players.iterator();
        if (iterator.hasNext()) {
            ServerPlayerEntity player = iterator.next();
            int cleared = 0;
            cleared += player.field_71071_by.func_234564_a_(stack -> !stack.func_190926_b() && stack.func_77973_b() == RegistrationHandler.itemTile, 64, (IInventory)player.field_71069_bz.func_234641_j_());
            CarryOn.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)new CarrySlotPacket(9, player.func_145782_y()));
            if ((cleared += player.field_71071_by.func_234564_a_(stack -> !stack.func_190926_b() && stack.func_77973_b() == RegistrationHandler.itemEntity, 64, (IInventory)player.field_71069_bz.func_234641_j_())) != 1) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Cleared " + cleared + " Items!"), true);
            } else {
                source.func_197030_a((ITextComponent)new StringTextComponent("Cleared " + cleared + " Item!"), true);
            }
            return 1;
        }
        return 0;
    }
}

