/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.api.terminalstorage.crafting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.TerminalCraftingJobStatus;

public class TerminalCraftingPlanStatic<I>
implements ITerminalCraftingPlan<I> {
    private final I id;
    private final List<ITerminalCraftingPlan<I>> dependencies;
    private final List<IPrototypedIngredient<?, ?>> outputs;
    private TerminalCraftingJobStatus status;
    private final long craftingQuantity;
    private final List<IPrototypedIngredient<?, ?>> storageIngredients;
    private final List<List<IPrototypedIngredient<?, ?>>> lastMissingIngredients;
    private Label label;
    @Nullable
    private String unlocalizedLabelOverride;
    private final long tickDuration;
    private final int channel;
    @Nullable
    private final String initiatorName;

    public TerminalCraftingPlanStatic(I id, List<ITerminalCraftingPlan<I>> dependencies, List<IPrototypedIngredient<?, ?>> outputs, TerminalCraftingJobStatus status, long craftingQuantity, List<IPrototypedIngredient<?, ?>> storageIngredients, List<List<IPrototypedIngredient<?, ?>>> lastMissingIngredients, Label label, long tickDuration, int channel, @Nullable String initiatorName) {
        this.id = id;
        this.dependencies = dependencies;
        this.outputs = outputs;
        this.status = status;
        this.craftingQuantity = craftingQuantity;
        this.storageIngredients = storageIngredients;
        this.lastMissingIngredients = lastMissingIngredients;
        this.label = label;
        this.unlocalizedLabelOverride = null;
        this.tickDuration = tickDuration;
        this.channel = channel;
        this.initiatorName = initiatorName;
    }

    @Override
    public I getId() {
        return this.id;
    }

    @Override
    public List<ITerminalCraftingPlan<I>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public List<IPrototypedIngredient<?, ?>> getOutputs() {
        return this.outputs;
    }

    @Override
    public TerminalCraftingJobStatus getStatus() {
        return this.status;
    }

    @Override
    public long getCraftingQuantity() {
        return this.craftingQuantity;
    }

    @Override
    public List<IPrototypedIngredient<?, ?>> getStorageIngredients() {
        return this.storageIngredients;
    }

    @Override
    public List<List<IPrototypedIngredient<?, ?>>> getLastMissingIngredients() {
        return this.lastMissingIngredients;
    }

    public Label getLabel() {
        return this.label;
    }

    @Nullable
    public String getUnlocalizedLabelOverride() {
        return this.unlocalizedLabelOverride;
    }

    public void setUnlocalizedLabelOverride(@Nullable String unlocalizedLabelOverride) {
        this.unlocalizedLabelOverride = unlocalizedLabelOverride;
    }

    @Override
    public String getUnlocalizedLabel() {
        if (this.unlocalizedLabelOverride == null) {
            return this.label.getUnlocalizedMessage();
        }
        return this.unlocalizedLabelOverride;
    }

    @Override
    public long getTickDuration() {
        return this.tickDuration;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    @Nullable
    public String getInitiatorName() {
        return this.initiatorName;
    }

    @Override
    public void setError(String unlocalizedError) {
        this.status = TerminalCraftingJobStatus.ERROR;
        this.unlocalizedLabelOverride = unlocalizedError;
    }

    public static <I> CompoundNBT serialize(TerminalCraftingPlanStatic<I> plan, ITerminalStorageTabIngredientCraftingHandler<?, I> handler) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("id", handler.serializeCraftingJobId(plan.getId()));
        ListNBT dependencies = new ListNBT();
        for (ITerminalCraftingPlan<I> iTerminalCraftingPlan : plan.getDependencies()) {
            dependencies.add((Object)TerminalCraftingPlanStatic.serialize((TerminalCraftingPlanStatic)iTerminalCraftingPlan, handler));
        }
        tag.func_218657_a("dependencies", (INBT)dependencies);
        ListNBT outputs = new ListNBT();
        for (IPrototypedIngredient<?, ?> iPrototypedIngredient : plan.getOutputs()) {
            outputs.add((Object)IPrototypedIngredient.serialize((IPrototypedIngredient)((PrototypedIngredient)iPrototypedIngredient)));
        }
        tag.func_218657_a("outputs", (INBT)outputs);
        tag.func_74768_a("status", plan.getStatus().ordinal());
        tag.func_74772_a("craftingQuantity", plan.getCraftingQuantity());
        ListNBT listNBT = new ListNBT();
        for (IPrototypedIngredient<?, ?> iPrototypedIngredient : plan.getStorageIngredients()) {
            listNBT.add((Object)IPrototypedIngredient.serialize((IPrototypedIngredient)((PrototypedIngredient)iPrototypedIngredient)));
        }
        tag.func_218657_a("storageIngredients", (INBT)listNBT);
        ListNBT listNBT2 = new ListNBT();
        for (List<IPrototypedIngredient<?, ?>> lastMissingIngredient : plan.getLastMissingIngredients()) {
            ListNBT lastMissingIngredientTag = new ListNBT();
            for (IPrototypedIngredient<?, ?> prototypedIngredient : lastMissingIngredient) {
                lastMissingIngredientTag.add((Object)IPrototypedIngredient.serialize((IPrototypedIngredient)((PrototypedIngredient)prototypedIngredient)));
            }
            listNBT2.add((Object)lastMissingIngredientTag);
        }
        tag.func_218657_a("lastMissingIngredients", (INBT)listNBT2);
        tag.func_74768_a("label", plan.label.ordinal());
        if (plan.unlocalizedLabelOverride != null) {
            tag.func_74778_a("unlocalizedLabelOverride", plan.unlocalizedLabelOverride);
        }
        tag.func_74772_a("tickDuration", plan.getTickDuration());
        tag.func_74768_a("channel", plan.getChannel());
        if (plan.getInitiatorName() != null) {
            tag.func_74778_a("initiatorName", plan.getInitiatorName());
        }
        return tag;
    }

    public static <I> TerminalCraftingPlanStatic<I> deserialize(CompoundNBT tag, ITerminalStorageTabIngredientCraftingHandler<?, I> handler) {
        if (!tag.func_74764_b("id")) {
            throw new IllegalArgumentException("Could not find an id entry in the given tag");
        }
        if (!tag.func_150297_b("dependencies", 9)) {
            throw new IllegalArgumentException("Could not find a dependencies entry in the given tag");
        }
        if (!tag.func_150297_b("outputs", 9)) {
            throw new IllegalArgumentException("Could not find a outputs entry in the given tag");
        }
        if (!tag.func_150297_b("status", 3)) {
            throw new IllegalArgumentException("Could not find a status entry in the given tag");
        }
        if (!tag.func_150297_b("craftingQuantity", 4)) {
            throw new IllegalArgumentException("Could not find a craftingQuantity entry in the given tag");
        }
        if (!tag.func_150297_b("storageIngredients", 9)) {
            throw new IllegalArgumentException("Could not find a storageIngredients entry in the given tag");
        }
        if (!tag.func_150297_b("lastMissingIngredients", 9)) {
            throw new IllegalArgumentException("Could not find a lastMissingIngredients entry in the given tag");
        }
        if (!tag.func_150297_b("label", 3)) {
            throw new IllegalArgumentException("Could not find a label entry in the given tag");
        }
        if (!tag.func_150297_b("tickDuration", 4)) {
            throw new IllegalArgumentException("Could not find a tickDuration entry in the given tag");
        }
        if (!tag.func_150297_b("channel", 3)) {
            throw new IllegalArgumentException("Could not find a channel entry in the given tag");
        }
        I id = handler.deserializeCraftingJobId(tag.func_74781_a("id"));
        ListNBT dependenciesTag = tag.func_150295_c("dependencies", 10);
        ArrayList dependencies = Lists.newArrayListWithExpectedSize((int)dependenciesTag.size());
        for (INBT nbtBase : dependenciesTag) {
            dependencies.add(TerminalCraftingPlanStatic.deserialize((CompoundNBT)nbtBase, handler));
        }
        ListNBT outputsTag = tag.func_150295_c("outputs", 10);
        ArrayList outputs = Lists.newArrayListWithExpectedSize((int)outputsTag.size());
        for (INBT nbtBase : outputsTag) {
            outputs.add(IPrototypedIngredient.deserialize((CompoundNBT)((CompoundNBT)nbtBase)));
        }
        TerminalCraftingJobStatus status = TerminalCraftingJobStatus.values()[tag.func_74762_e("status")];
        long craftingQuantity = tag.func_74763_f("craftingQuantity");
        ListNBT storageIngredientsTag = tag.func_150295_c("storageIngredients", 10);
        ArrayList storageIngredients = Lists.newArrayListWithExpectedSize((int)storageIngredientsTag.size());
        for (INBT nbtBase : storageIngredientsTag) {
            storageIngredients.add(IPrototypedIngredient.deserialize((CompoundNBT)((CompoundNBT)nbtBase)));
        }
        ListNBT lastMissingIngredientsTag = tag.func_150295_c("lastMissingIngredients", 9);
        ArrayList lastMissingIngredients = Lists.newArrayListWithExpectedSize((int)lastMissingIngredientsTag.size());
        for (INBT nbtBase : lastMissingIngredientsTag) {
            ListNBT list = (ListNBT)nbtBase;
            ArrayList lastMissingIngredient = Lists.newArrayListWithExpectedSize((int)list.size());
            for (INBT base : list) {
                lastMissingIngredient.add(IPrototypedIngredient.deserialize((CompoundNBT)((CompoundNBT)base)));
            }
            lastMissingIngredients.add(lastMissingIngredient);
        }
        Label label = Label.values()[tag.func_74762_e("label")];
        String unlocalizedLabelOverride = null;
        if (tag.func_74764_b("unlocalizedLabelOverride")) {
            unlocalizedLabelOverride = tag.func_74779_i("unlocalizedLabelOverride");
        }
        long tickDuration = tag.func_74763_f("tickDuration");
        int channel = tag.func_74762_e("channel");
        String initiatorName = null;
        if (tag.func_150297_b("initiatorName", 8)) {
            initiatorName = tag.func_74779_i("initiatorName");
        }
        TerminalCraftingPlanStatic<I> plan = new TerminalCraftingPlanStatic<I>(id, dependencies, outputs, status, craftingQuantity, storageIngredients, lastMissingIngredients, label, tickDuration, channel, initiatorName);
        if (unlocalizedLabelOverride != null) {
            plan.unlocalizedLabelOverride = unlocalizedLabelOverride;
        }
        return plan;
    }

    public static enum Label {
        RUNNING("gui.integratedterminals.terminal_storage.craftingplan.label.running"),
        VALID("gui.integratedterminals.terminal_storage.craftingplan.label.valid"),
        INCOMPLETE("gui.integratedterminals.terminal_storage.craftingplan.label.failed.incomplete"),
        RECURSION("gui.integratedterminals.terminal_storage.craftingplan.label.failed.recursion"),
        ERROR("ERROR");

        private final String unlocalizedMessage;

        private Label(String unlocalizedMessage) {
            this.unlocalizedMessage = unlocalizedMessage;
        }

        public String getUnlocalizedMessage() {
            return this.unlocalizedMessage;
        }
    }
}

