/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonExtended;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetNumberField;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingOption;
import org.cyclops.integratedterminals.capability.ingredient.IngredientComponentTerminalStorageHandlerConfig;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageCraftingOptionAmountBase;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientOpenCraftingPlanGuiPacket;

public class ContainerScreenTerminalStorageCraftingOptionAmount<L, C extends ContainerTerminalStorageCraftingOptionAmountBase<L>>
extends ContainerScreenExtended<C> {
    public static int OUTPUT_SLOT_X = 135;
    public static int OUTPUT_SLOT_Y = 15;
    private final List<IPrototypedIngredient<?, ?>> outputs = Lists.newArrayList();
    private WidgetNumberField numberField = null;
    private WidgetScrollBar scrollBar;
    private int firstRow;
    private ButtonText nextButton;

    public ContainerScreenTerminalStorageCraftingOptionAmount(C container, PlayerInventory inventory, ITextComponent title) {
        super(container, inventory, title);
        ITerminalCraftingOption<?> option = ((ContainerTerminalStorageCraftingOptionAmountBase)this.func_212873_a_()).getCraftingOptionGuiData().getCraftingOption().getCraftingOption();
        for (IngredientComponent<?, ?> outputComponent : option.getOutputComponents()) {
            for (Object output : option.getOutputs(outputComponent)) {
                this.outputs.add((IPrototypedIngredient<?, ?>)new PrototypedIngredient(outputComponent, output, null));
            }
        }
    }

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integratedterminals", "textures/gui/crafting_option_amount.png");
    }

    public int getBaseXSize() {
        return 178;
    }

    public int getBaseYSize() {
        return 162;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.numberField = new WidgetNumberField(Minecraft.func_71410_x().field_71466_p, this.field_147003_i + 25, this.field_147009_r + 36, 53, 14, true, (ITextComponent)new TranslationTextComponent("gui.integratedterminals.amount"), true);
        this.numberField.setPositiveOnly(true);
        this.numberField.func_146203_f(5);
        this.numberField.setMaxValue(10000);
        this.numberField.setMinValue(1);
        this.numberField.func_146189_e(true);
        this.numberField.func_146193_g(0xFFFFFF);
        this.numberField.func_146205_d(true);
        this.numberField.func_146180_a("1");
        this.field_230705_e_.add(this.numberField);
        this.scrollBar = new WidgetScrollBar(this.field_147003_i + 153, this.field_147009_r + 15, 54, (ITextComponent)new TranslationTextComponent("gui.cyclopscore.scrollbar"), this::setFirstRow, 3);
        this.scrollBar.setTotalRows(this.outputs.size() - 1);
        this.field_230705_e_.add(this.scrollBar);
        this.func_230480_a_((Widget)new ButtonChangeQuantity(this.field_147003_i + 5, this.field_147009_r + 10, 10, this::buttonChangeQuantity));
        this.func_230480_a_((Widget)new ButtonChangeQuantity(this.field_147003_i + 5, this.field_147009_r + 55, -10, this::buttonChangeQuantity));
        this.func_230480_a_((Widget)new ButtonChangeQuantity(this.field_147003_i + 48, this.field_147009_r + 10, 100, this::buttonChangeQuantity));
        this.func_230480_a_((Widget)new ButtonChangeQuantity(this.field_147003_i + 48, this.field_147009_r + 55, -100, this::buttonChangeQuantity));
        this.func_230480_a_((Widget)new ButtonChangeQuantity(this.field_147003_i + 91, this.field_147009_r + 10, 1000, this::buttonChangeQuantity));
        this.func_230480_a_((Widget)new ButtonChangeQuantity(this.field_147003_i + 91, this.field_147009_r + 55, -1000, this::buttonChangeQuantity));
        this.nextButton = new ButtonText(this.field_147003_i + 81, this.field_147009_r + 33, 50, 20, (ITextComponent)new TranslationTextComponent("gui.integratedterminals.terminal_storage.step.next"), (ITextComponent)new TranslationTextComponent("gui.integratedterminals.terminal_storage.step.next").func_240699_a_(TextFormatting.YELLOW), bb -> this.calculateCraftingJob(), true);
        this.func_230480_a_((Widget)this.nextButton);
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        return this.numberField.func_231042_a_(typedChar, keyCode) || super.func_231042_a_(typedChar, keyCode);
    }

    public boolean func_231046_a_(int typedChar, int keyCode, int modifiers) {
        if (typedChar == 256) {
            this.returnToTerminalStorage();
            return true;
        }
        if (typedChar == 257 || typedChar == 335) {
            this.calculateCraftingJob();
            return true;
        }
        return this.numberField.func_231046_a_(typedChar, keyCode, modifiers) || super.func_231046_a_(typedChar, keyCode, modifiers);
    }

    private void returnToTerminalStorage() {
        CraftingOptionGuiData data = ((ContainerTerminalStorageCraftingOptionAmountBase)this.func_212873_a_()).getCraftingOptionGuiData();
        data.getLocation().openContainerFromClient(data);
    }

    public void buttonChangeQuantity(Button button) {
        if (button instanceof ButtonChangeQuantity) {
            int diff = ((ButtonChangeQuantity)button).getDiff();
            this.setAmount(this.getAmount() + diff);
        }
    }

    private void calculateCraftingJob() {
        CraftingOptionGuiData craftingOptionData = ((ContainerTerminalStorageCraftingOptionAmountBase)this.func_212873_a_()).getCraftingOptionGuiData().copyWithAmount(this.getAmount());
        IntegratedTerminals._instance.getPacketHandler().sendToServer(new TerminalStorageIngredientOpenCraftingPlanGuiPacket(craftingOptionData));
    }

    protected <T, M> void drawInstance(MatrixStack matrixStack, IngredientComponent<T, M> ingredientComponent, T instance, int x, int y, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int mouseX, int mouseY) {
        long quantity = ingredientComponent.getMatcher().getQuantity(instance) * (long)this.getAmount();
        ((IIngredientComponentTerminalStorageHandler)ingredientComponent.getCapability(IngredientComponentTerminalStorageHandlerConfig.CAPABILITY).orElseThrow(() -> new IllegalStateException("Could not find ingredient terminal storage handler"))).drawInstance(matrixStack, ingredientComponent.getMatcher().withQuantity(instance, quantity), quantity, GuiHelpers.quantityToScaledString((long)quantity), (ContainerScreen)this, layer, partialTick, x, y, mouseX, mouseY, null);
    }

    private int getAmount() {
        try {
            return this.numberField.getInt();
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    private void setAmount(int amount) {
        this.numberField.func_146180_a(Integer.toString(this.numberField.validateNumber(amount)));
    }

    protected void drawOutputSlots(MatrixStack matrixStack, int x, int y, float partialTicks, int mouseX, int mouseY, ContainerScreenTerminalStorage.DrawLayer layer) {
        int offsetY = OUTPUT_SLOT_Y;
        for (IPrototypedIngredient<?, ?> output : this.outputs.subList(this.firstRow, Math.min(this.outputs.size(), this.firstRow + this.scrollBar.getVisibleRows()))) {
            this.drawInstance(matrixStack, output.getComponent(), output.getPrototype(), x + OUTPUT_SLOT_X, y + offsetY, layer, partialTicks, mouseX, mouseY);
            offsetY += GuiHelpers.SLOT_SIZE;
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        this.numberField.func_230431_b_(matrixStack, mouseX - this.field_147003_i, mouseY - this.field_147009_r, partialTicks);
        this.scrollBar.drawGuiContainerBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
        RenderHelpers.bindTexture((ResourceLocation)this.texture);
        this.drawOutputSlots(matrixStack, this.field_147003_i, this.field_147009_r, partialTicks, mouseX - this.field_147003_i, mouseY - this.field_147009_r, ContainerScreenTerminalStorage.DrawLayer.BACKGROUND);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.drawOutputSlots(matrixStack, 0, 0, 0.0f, mouseX, mouseY, ContainerScreenTerminalStorage.DrawLayer.FOREGROUND);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseButton, double mouseXPrev, double mouseYPrev) {
        return this.func_241217_q_() != null && this.func_231041_ay__() && mouseButton == 0 && this.func_241217_q_().func_231045_a_(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev) ? true : super.func_231045_a_(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = firstRow;
    }

    public class ButtonChangeQuantity
    extends ButtonExtended {
        private final int diff;

        public ButtonChangeQuantity(int x, int y, int diff, Button.IPressable pressCallback) {
            super(x, y, 40, 20, (ITextComponent)new StringTextComponent((diff < 0 ? "- " : "+ ") + Integer.toString(Math.abs(diff))), pressCallback, true);
            this.diff = diff;
        }

        protected void drawButtonInner(MatrixStack matrixStack, int i, int j) {
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int color = 0xE0E0E0;
            if (!this.field_230693_o_) {
                color = 0xA0A0A0;
            } else if (this.func_230449_g_()) {
                color = 0xFFFFA0;
            }
            ButtonChangeQuantity.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)((ContainerScreenTerminalStorageCraftingOptionAmount)ContainerScreenTerminalStorageCraftingOptionAmount.this).field_230706_i_.field_71466_p, (ITextComponent)this.func_230458_i_(), (int)(this.field_230690_l_ + this.field_230688_j_ / 2), (int)(this.field_230691_m_ + (this.field_230689_k_ - 8) / 2), (int)color);
        }

        public int getDiff() {
            return this.diff;
        }
    }
}

