/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonItemStackCraftingGridAutoRefill;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonItemStackCraftingGridBalance;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonItemStackCraftingGridClear;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientItemStackCraftingGridShiftClickOutput;

public class TerminalStorageTabIngredientComponentItemStackCraftingClient
extends TerminalStorageTabIngredientComponentClient<ItemStack, Integer> {
    private final ItemStack icon = new ItemStack((IItemProvider)Blocks.field_150462_ai);

    public TerminalStorageTabIngredientComponentItemStackCraftingClient(ContainerTerminalStorageBase container, ResourceLocation name, IngredientComponent<?, ?> ingredientComponent) {
        super(container, name, ingredientComponent);
    }

    @Override
    public ResourceLocation getTabSettingsName() {
        return GeneralConfig.syncItemStorageAndCraftingTabStates ? this.ingredientComponent.getName() : this.getName();
    }

    @Override
    protected void loadButtons(List<ITerminalButton<?, ?, ?>> buttons) {
        super.loadButtons(buttons);
        buttons.add(new TerminalButtonItemStackCraftingGridAutoRefill(this.container.getGuiState(), this));
        buttons.add(new TerminalButtonItemStackCraftingGridClear());
        buttons.add(new TerminalButtonItemStackCraftingGridBalance());
    }

    @Override
    public ItemStack getIcon() {
        return this.icon;
    }

    @Override
    public List<ITextComponent> getTooltip() {
        return Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("gui.integratedterminals.terminal_storage.crafting_name", new Object[]{new TranslationTextComponent(this.ingredientComponent.getTranslationKey())})});
    }

    @Override
    public int getSlotOffsetX() {
        return 139;
    }

    @Override
    public int getSlotRowLength() {
        return 3;
    }

    @Override
    @Nullable
    public ResourceLocation getBackgroundTexture() {
        return new ResourceLocation("integratedterminals", (String)IntegratedTerminals._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_GUI) + "part_terminal_storage_crafting.png");
    }

    @Override
    public boolean handleClick(Container container, int channel, int hoveringStorageSlot, int mouseButton, boolean hasClickedOutside, boolean hasClickedInStorage, int hoveredContainerSlot) {
        int craftingResultSlotIndex = TerminalStorageTabIngredientComponentItemStackCraftingCommon.getCraftingResultSlotIndex(container, this.getName());
        boolean shift = MinecraftHelpers.isShifted();
        if (hoveredContainerSlot == craftingResultSlotIndex && shift) {
            IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new TerminalStorageIngredientItemStackCraftingGridShiftClickOutput(this.getName().toString(), channel, GeneralConfig.shiftClickCraftingResultLimit));
            return true;
        }
        if (hoveredContainerSlot > craftingResultSlotIndex && hoveredContainerSlot <= craftingResultSlotIndex + 9 && this.getActiveSlotId() < 0) {
            return false;
        }
        return super.handleClick(container, channel, hoveringStorageSlot, mouseButton, hasClickedOutside, hasClickedInStorage, hoveredContainerSlot);
    }

    @Override
    public void onCommonSlotRender(ContainerScreen gui, MatrixStack matrixStack, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY, int slot, ITerminalStorageTabCommon tabCommon) {
        String name = this.ingredientComponent.getName().toString();
        ITerminalStorageTabClient tabClient = this.container.getTabClient(name);
        tabCommon = this.container.getTabCommon(name);
        tabClient.onCommonSlotRender(gui, matrixStack, layer, partialTick, x, y, mouseX, mouseY, slot, tabCommon);
    }
}

