/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageItem;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;
import org.cyclops.integratedterminals.item.ItemTerminalStoragePortable;

public class TerminalStorageIngredientItemOpenPacket
extends PacketCodec {
    @CodecField
    private int slot;
    @CodecField
    private String handName;
    @CodecField
    private String tabName;
    @CodecField
    private int channel;

    public TerminalStorageIngredientItemOpenPacket() {
    }

    public TerminalStorageIngredientItemOpenPacket(Pair<Hand, Integer> location, String tabName, int channel) {
        this.slot = (Integer)location.getRight();
        this.handName = ((Hand)location.getLeft()).name();
        this.tabName = tabName;
        this.channel = channel;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(World world, PlayerEntity player) {
    }

    public void actionServer(World world, ServerPlayerEntity player) {
        TerminalStorageIngredientItemOpenPacket.openServer(world, (Pair<Hand, Integer>)Pair.of((Object)Hand.valueOf((String)this.handName), (Object)this.slot), player, this.tabName, this.channel);
    }

    public static void openServer(World world, final Pair<Hand, Integer> location, ServerPlayerEntity player, String tabName, int channel) {
        final ContainerTerminalStorageBase.InitTabData initData = new ContainerTerminalStorageBase.InitTabData(tabName, channel);
        final TerminalStorageState terminalStorageState = ItemTerminalStoragePortable.getTerminalStorageState(InventoryHelpers.getItemFromIndex((PlayerEntity)player, (int)((Integer)location.getRight()), (Hand)((Hand)location.getLeft())), (PlayerEntity)player, (Integer)location.getRight(), (Hand)location.getLeft());
        INamedContainerProvider containerProvider = new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("");
            }

            public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return new ContainerTerminalStorageItem(id, playerInventory, (Integer)location.getRight(), (Hand)location.getLeft(), Optional.of(initData), terminalStorageState);
            }
        };
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)containerProvider, packetBuffer -> {
            packetBuffer.writeInt(((Integer)location.getRight()).intValue());
            packetBuffer.writeBoolean(location.getLeft() == Hand.MAIN_HAND);
            packetBuffer.writeBoolean(true);
            initData.writeToPacketBuffer((PacketBuffer)packetBuffer);
            terminalStorageState.writeToPacketBuffer((PacketBuffer)packetBuffer);
        });
    }

    public static void send(Pair<Hand, Integer> location, String tabName, int channel) {
        IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new TerminalStorageIngredientItemOpenPacket(location, tabName, channel));
    }
}

