/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.common.light;

import ca.spottedleaf.starlight.common.blockstate.ExtendedAbstractBlockState;
import ca.spottedleaf.starlight.common.chunk.ExtendedChunk;
import ca.spottedleaf.starlight.common.light.SWMRNibbleArray;
import ca.spottedleaf.starlight.common.light.StarLightEngine;
import ca.spottedleaf.starlight.common.light.VariableBlockLightHandler;
import ca.spottedleaf.starlight.common.world.ExtendedWorld;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.palette.PalettedContainer;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimerWrapper;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkLightProvider;

public final class BlockStarLightEngine
extends StarLightEngine {
    protected final BlockPos.Mutable recalcCenterPos = new BlockPos.Mutable();
    protected final BlockPos.Mutable recalcNeighbourPos = new BlockPos.Mutable();

    public BlockStarLightEngine(World world) {
        super(false, world);
    }

    @Override
    protected boolean[] getEmptinessMap(IChunk chunk) {
        return ((ExtendedChunk)chunk).getBlockEmptinessMap();
    }

    @Override
    protected void setEmptinessMap(IChunk chunk, boolean[] to) {
        ((ExtendedChunk)chunk).setBlockEmptinessMap(to);
    }

    @Override
    protected SWMRNibbleArray[] getNibblesOnChunk(IChunk chunk) {
        return ((ExtendedChunk)chunk).getBlockNibbles();
    }

    @Override
    protected void setNibbles(IChunk chunk, SWMRNibbleArray[] to) {
        ((ExtendedChunk)chunk).setBlockNibbles(to);
    }

    @Override
    protected boolean canUseChunk(IChunk chunk) {
        return chunk.func_201589_g().func_209003_a(ChunkStatus.field_222614_j) && (this.isClientSide || chunk.func_217310_r());
    }

    @Override
    protected void setNibbleNull(int chunkX, int chunkY, int chunkZ) {
        SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
        if (nibble != null) {
            nibble.setHidden();
        }
    }

    @Override
    protected void initNibble(int chunkX, int chunkY, int chunkZ, boolean extrude, boolean initRemovedNibbles) {
        if (chunkY < this.minLightSection || chunkY > this.maxLightSection || this.getChunkInCache(chunkX, chunkZ) == null) {
            return;
        }
        SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
        if (nibble == null) {
            if (!initRemovedNibbles) {
                throw new IllegalStateException();
            }
            this.setNibbleInCache(chunkX, chunkY, chunkZ, new SWMRNibbleArray());
        } else {
            nibble.setNonNull();
        }
    }

    @Override
    protected final void checkBlock(IChunkLightProvider lightAccess, int worldX, int worldY, int worldZ) {
        int encodeOffset = this.coordinateOffset;
        int emittedMask = this.emittedLightMask;
        VariableBlockLightHandler customBlockHandler = ((ExtendedWorld)lightAccess.func_212864_k_()).getCustomLightHandler();
        int currentLevel = this.getLightLevel(worldX, worldY, worldZ);
        BlockState blockState = this.getBlockState(worldX, worldY, worldZ);
        int emittedLevel = (customBlockHandler != null ? this.getCustomLightLevel(customBlockHandler, worldX, worldY, worldZ, blockState.func_185906_d()) : blockState.func_185906_d()) & emittedMask;
        this.setLightLevel(worldX, worldY, worldZ, emittedLevel);
        if (emittedLevel != 0) {
            this.appendToIncreaseQueue((long)(worldX + (worldZ << 6) + (worldY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)emittedLevel & 0xFL) << 28 | 0x3F00000000L | (((ExtendedAbstractBlockState)blockState).isConditionallyFullOpaque() ? Long.MIN_VALUE : 0L));
        }
        this.appendToDecreaseQueue((long)(worldX + (worldZ << 6) + (worldY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)currentLevel & 0xFL) << 28 | 0x3F00000000L);
    }

    @Override
    protected int calculateLightValue(IChunkLightProvider lightAccess, int worldX, int worldY, int worldZ, int expect, VariableBlockLightHandler customBlockLight) {
        Object conditionallyOpaqueState;
        BlockState centerState = this.getBlockState(worldX, worldY, worldZ);
        int level = centerState.func_185906_d() & 0xF;
        if (customBlockLight != null) {
            level = this.getCustomLightLevel(customBlockLight, worldX, worldY, worldZ, level);
        }
        if (level >= 14 || level > expect) {
            return level;
        }
        int sectionOffset = this.chunkSectionIndexOffset;
        int opacity = ((ExtendedAbstractBlockState)centerState).getOpacityIfCached();
        if (opacity == -1) {
            this.recalcCenterPos.func_181079_c(worldX, worldY, worldZ);
            opacity = centerState.func_200016_a(lightAccess.func_212864_k_(), (BlockPos)this.recalcCenterPos);
            conditionallyOpaqueState = ((ExtendedAbstractBlockState)centerState).isConditionallyFullOpaque() ? centerState : null;
        } else {
            if (opacity >= 15) {
                return level;
            }
            conditionallyOpaqueState = null;
        }
        opacity = Math.max(1, opacity);
        for (StarLightEngine.AxisDirection direction : AXIS_DIRECTIONS) {
            int calculated;
            int offX = worldX + direction.x;
            int offZ = worldZ + direction.z;
            int offY = worldY + direction.y;
            int sectionIndex = (offX >> 4) + 5 * (offZ >> 4) + 25 * (offY >> 4) + sectionOffset;
            int neighbourLevel = this.getLightLevel(sectionIndex, offX & 0xF | (offZ & 0xF) << 4 | (offY & 0xF) << 8);
            if (neighbourLevel - 1 <= level) continue;
            long neighbourOpacity = this.getKnownTransparency(sectionIndex, offY & 0xF | (offX & 0xF) << 4 | (offZ & 0xF) << 8);
            if (neighbourOpacity == 3L) {
                VoxelShape thisFace;
                BlockState neighbourState = this.getBlockState(offX, offY, offZ);
                this.recalcNeighbourPos.func_181079_c(offX, offY, offZ);
                VoxelShape neighbourFace = neighbourState.func_215702_a(lightAccess.func_212864_k_(), (BlockPos)this.recalcNeighbourPos, direction.opposite.nms);
                VoxelShape voxelShape = thisFace = conditionallyOpaqueState == null ? VoxelShapes.func_197880_a() : conditionallyOpaqueState.func_215702_a(lightAccess.func_212864_k_(), (BlockPos)this.recalcCenterPos, direction.nms);
                if (VoxelShapes.func_223416_b((VoxelShape)thisFace, (VoxelShape)neighbourFace)) continue;
            }
            if ((level = Math.max(calculated = neighbourLevel - opacity, level)) <= expect) continue;
            return level;
        }
        return level;
    }

    @Override
    protected void propagateBlockChanges(IChunkLightProvider lightAccess, IChunk atChunk, Set<BlockPos> positions) {
        for (BlockPos pos : positions) {
            this.checkBlock(lightAccess, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        this.performLightDecrease(lightAccess);
    }

    protected Iterator<BlockPos> getSources(IChunkLightProvider lightAccess, IChunk chunk) {
        if (chunk instanceof ChunkPrimerWrapper || chunk instanceof Chunk) {
            ArrayList<BlockPos> sources = new ArrayList<BlockPos>();
            int offX = chunk.func_76632_l().field_77276_a << 4;
            int offZ = chunk.func_76632_l().field_77275_b << 4;
            ChunkSection[] sections = chunk.func_76587_i();
            for (int sectionY = this.minSection; sectionY <= this.maxSection; ++sectionY) {
                ChunkSection section = sections[sectionY - this.minSection];
                if (section == null || section.func_76663_a()) continue;
                PalettedContainer states = section.field_177488_d;
                int offY = sectionY << 4;
                for (int index = 0; index < 4096; ++index) {
                    BlockState state = (BlockState)states.func_186015_a(index);
                    if (state.func_185906_d() <= 0) continue;
                    sources.add(new BlockPos(offX | index & 0xF, offY | index >>> 8, offZ | index >>> 4 & 0xF));
                }
            }
            VariableBlockLightHandler customBlockHandler = ((ExtendedWorld)lightAccess.func_212864_k_()).getCustomLightHandler();
            if (customBlockHandler == null) {
                return sources.iterator();
            }
            HashSet<BlockPos> ret = new HashSet<BlockPos>(sources);
            ret.addAll(customBlockHandler.getCustomLightPositions(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b));
            return ret.iterator();
        }
        while (true) {
            try {
                return chunk.func_217304_m().collect(Collectors.toList()).iterator();
            }
            catch (Exception cme) {
                continue;
            }
            break;
        }
    }

    @Override
    public void lightChunk(IChunkLightProvider lightAccess, IChunk chunk, boolean needsEdgeChecks) {
        int emittedMask = this.emittedLightMask;
        VariableBlockLightHandler customBlockHandler = ((ExtendedWorld)lightAccess.func_212864_k_()).getCustomLightHandler();
        Iterator<BlockPos> positions = this.getSources(lightAccess, chunk);
        while (positions.hasNext()) {
            BlockPos pos = positions.next();
            BlockState blockState = this.getBlockState(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            int emittedLight = (customBlockHandler != null ? this.getCustomLightLevel(customBlockHandler, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), blockState.func_185906_d()) : blockState.func_185906_d()) & emittedMask;
            if (emittedLight <= this.getLightLevel(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) continue;
            this.appendToIncreaseQueue((long)(pos.func_177958_n() + (pos.func_177952_p() << 6) + (pos.func_177956_o() << 12) + this.coordinateOffset) & 0xFFFFFFFL | ((long)emittedLight & 0xFL) << 28 | 0x3F00000000L | (((ExtendedAbstractBlockState)blockState).isConditionallyFullOpaque() ? Long.MIN_VALUE : 0L));
            this.setLightLevel(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), emittedLight);
        }
        if (needsEdgeChecks) {
            this.performLightIncrease(lightAccess);
            this.checkChunkEdges(lightAccess, chunk, this.minLightSection, this.maxLightSection);
        } else {
            this.propagateNeighbourLevels(lightAccess, chunk, this.minLightSection, this.maxLightSection);
            this.performLightIncrease(lightAccess);
        }
    }
}

