/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.common.util;

import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;

public final class CoordinateUtils {
    static final int SECTION_X_BITS = 22;
    static final long SECTION_X_MASK = 0x3FFFFFL;
    static final int SECTION_Y_BITS = 20;
    static final long SECTION_Y_MASK = 1048575L;
    static final int SECTION_Z_BITS = 22;
    static final long SECTION_Z_MASK = 0x3FFFFFL;
    static final int SECTION_Y_SHIFT = 0;
    static final int SECTION_Z_SHIFT = 20;
    static final int SECTION_X_SHIFT = 42;
    static final int SECTION_TO_BLOCK_SHIFT = 4;

    public static int getNeighbourMappedIndex(int dx, int dz, int radius) {
        return dx + radius + (2 * radius + 1) * (dz + radius);
    }

    public static long getChunkKey(BlockPos pos) {
        return (long)(pos.func_177952_p() >> 4) << 32 | (long)(pos.func_177958_n() >> 4) & 0xFFFFFFFFL;
    }

    public static long getChunkKey(Entity entity) {
        return (long)(MathHelper.func_76128_c((double)entity.func_226281_cx_()) >> 4) << 32 | (long)(MathHelper.func_76128_c((double)entity.func_226277_ct_()) >> 4) & 0xFFFFFFFFL;
    }

    public static long getChunkKey(ChunkPos pos) {
        return (long)pos.field_77275_b << 32 | (long)pos.field_77276_a & 0xFFFFFFFFL;
    }

    public static long getChunkKey(SectionPos pos) {
        return (long)pos.func_177952_p() << 32 | (long)pos.func_177958_n() & 0xFFFFFFFFL;
    }

    public static long getChunkKey(int x, int z) {
        return (long)z << 32 | (long)x & 0xFFFFFFFFL;
    }

    public static int getChunkX(long chunkKey) {
        return (int)chunkKey;
    }

    public static int getChunkZ(long chunkKey) {
        return (int)(chunkKey >>> 32);
    }

    public static int getChunkCoordinate(double blockCoordinate) {
        return MathHelper.func_76128_c((double)blockCoordinate) >> 4;
    }

    public static long getChunkSectionKey(int x, int y, int z) {
        return ((long)x & 0x3FFFFFL) << 42 | ((long)y & 0xFFFFFL) << 0 | ((long)z & 0x3FFFFFL) << 20;
    }

    public static long getChunkSectionKey(SectionPos pos) {
        return ((long)pos.func_177958_n() & 0x3FFFFFL) << 42 | ((long)pos.func_177956_o() & 0xFFFFFL) << 0 | ((long)pos.func_177952_p() & 0x3FFFFFL) << 20;
    }

    public static long getChunkSectionKey(ChunkPos pos, int y) {
        return ((long)pos.field_77276_a & 0x3FFFFFL) << 42 | ((long)y & 0xFFFFFL) << 0 | ((long)pos.field_77275_b & 0x3FFFFFL) << 20;
    }

    public static long getChunkSectionKey(BlockPos pos) {
        return (long)pos.func_177958_n() << 38 & 0xFFFFFC0000000000L | (long)(pos.func_177956_o() >> 4) & 0xFFFFFL | (long)pos.func_177952_p() << 16 & 0x3FFFFF00000L;
    }

    public static long getChunkSectionKey(Entity entity) {
        return MathHelper.func_76124_d((double)entity.func_226277_ct_()) << 38 & 0xFFFFFC0000000000L | MathHelper.func_76124_d((double)entity.func_226278_cu_()) >> 4 & 0xFFFFFL | MathHelper.func_76124_d((double)entity.func_226281_cx_()) << 16 & 0x3FFFFF00000L;
    }

    public static int getChunkSectionX(long key) {
        return (int)(key << 0 >> 42);
    }

    public static int getChunkSectionY(long key) {
        return (int)(key << 44 >> 44);
    }

    public static int getChunkSectionZ(long key) {
        return (int)(key << 22 >> 42);
    }

    public static int getBlockCoordinate(double blockCoordinate) {
        return MathHelper.func_76128_c((double)blockCoordinate);
    }

    public static long getBlockKey(int x, int y, int z) {
        return (long)x & 0x7FFFFFFL | ((long)z & 0x7FFFFFFL) << 27 | (long)y << 54;
    }

    public static long getBlockKey(BlockPos pos) {
        return (long)pos.func_177958_n() & 0x7FFFFFFL | ((long)pos.func_177952_p() & 0x7FFFFFFL) << 27 | (long)pos.func_177956_o() << 54;
    }

    public static long getBlockKey(Entity entity) {
        return (long)entity.func_226277_ct_() & 0x7FFFFFFL | ((long)entity.func_226281_cx_() & 0x7FFFFFFL) << 27 | (long)entity.func_226278_cu_() << 54;
    }

    private CoordinateUtils() {
        throw new RuntimeException();
    }
}

