/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.mixin.common.chunk;

import ca.spottedleaf.starlight.common.blockstate.ExtendedAbstractBlockState;
import ca.spottedleaf.starlight.common.chunk.ExtendedChunkSection;
import net.minecraft.block.BlockState;
import net.minecraft.util.palette.PalettedContainer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkSection.class})
public abstract class ChunkSectionMixin
implements ExtendedChunkSection {
    @Final
    @Shadow
    public PalettedContainer<BlockState> field_177488_d;
    @Unique
    protected int transparentBlockCount;
    @Unique
    private final long[] knownBlockTransparencies = new long[128];

    @Unique
    private static long getKnownTransparency(BlockState state) {
        int opacityIfCached = ((ExtendedAbstractBlockState)state).getOpacityIfCached();
        if (opacityIfCached == 0) {
            return 0L;
        }
        if (opacityIfCached == 15) {
            return 1L;
        }
        return opacityIfCached == -1 ? 3L : 2L;
    }

    @Unique
    private void updateTransparencyInfo(int blockIndex, long transparency) {
        int arrayIndex = blockIndex >>> 5;
        int valueShift = (blockIndex & 0x1F) << 1;
        long value = this.knownBlockTransparencies[arrayIndex];
        value &= 3L << valueShift ^ 0xFFFFFFFFFFFFFFFFL;
        this.knownBlockTransparencies[arrayIndex] = value |= transparency << valueShift;
    }

    @Unique
    private void initKnownTransparenciesData() {
        this.transparentBlockCount = 0;
        for (int y = 0; y <= 15; ++y) {
            for (int z = 0; z <= 15; ++z) {
                for (int x = 0; x <= 15; ++x) {
                    long transparency = ChunkSectionMixin.getKnownTransparency((BlockState)this.field_177488_d.func_186016_a(x, y, z));
                    if (transparency == 0L) {
                        ++this.transparentBlockCount;
                    }
                    this.updateTransparencyInfo(y | x << 4 | z << 8, transparency);
                }
            }
        }
    }

    @Inject(method={"recalculateRefCounts"}, at={@At(value="RETURN")})
    private void initKnownTransparenciesDataServerSide(CallbackInfo ci) {
        this.initKnownTransparenciesData();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"read"}, at={@At(value="RETURN")})
    private void initKnownTransparenciesDataClientSide(CallbackInfo ci) {
        this.initKnownTransparenciesData();
    }

    @Inject(method={"setBlockState(IIILnet/minecraft/block/BlockState;Z)Lnet/minecraft/block/BlockState;"}, at={@At(value="RETURN")})
    private void updateBlockCallback(int x, int y, int z, BlockState state, boolean lock, CallbackInfoReturnable<BlockState> cir) {
        BlockState oldState = (BlockState)cir.getReturnValue();
        long oldTransparency = ChunkSectionMixin.getKnownTransparency(oldState);
        long newTransparency = ChunkSectionMixin.getKnownTransparency(state);
        if (oldTransparency == 0L) {
            --this.transparentBlockCount;
        }
        if (newTransparency == 0L) {
            ++this.transparentBlockCount;
        }
        this.updateTransparencyInfo(y | x << 4 | z << 8, newTransparency);
    }

    @Override
    public final boolean hasOpaqueBlocks() {
        return this.transparentBlockCount != 4096;
    }

    @Override
    public final long getKnownTransparency(int blockIndex) {
        int arrayIndex = blockIndex >>> 5;
        int valueShift = (blockIndex & 0x1F) << 1;
        long value = this.knownBlockTransparencies[arrayIndex];
        return value >>> valueShift & 3L;
    }

    @Override
    public final long getBitsetForColumn(int columnX, int columnZ) {
        int columnIndex = columnX << 4 | columnZ << 8;
        long value = this.knownBlockTransparencies[columnIndex >>> 5];
        int startIndex = (columnIndex & 0x1F) << 1;
        return value >>> startIndex & 0xFFFFFFFFL;
    }
}

