/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.mixin.common.lightengine;

import ca.spottedleaf.starlight.common.light.StarLightEngine;
import ca.spottedleaf.starlight.common.light.StarLightInterface;
import ca.spottedleaf.starlight.common.light.StarLightLightingProvider;
import ca.spottedleaf.starlight.common.util.CoordinateUtils;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.ServerWorldLightManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ServerWorldLightManager.class})
public abstract class ServerWorldLightManagerMixin
extends WorldLightManager
implements StarLightLightingProvider {
    @Final
    @Shadow
    private ChunkManager field_215607_d;
    @Final
    @Shadow
    private static Logger field_215604_a;
    @Unique
    private final Long2IntOpenHashMap chunksBeingWorkedOn = new Long2IntOpenHashMap();

    @Shadow
    public abstract void func_215588_z_();

    public ServerWorldLightManagerMixin(IChunkLightProvider chunkProvider, boolean hasBlockLight, boolean hasSkyLight) {
        super(chunkProvider, hasBlockLight, hasSkyLight);
    }

    @Unique
    private void queueTaskForSection(int chunkX, int chunkY, int chunkZ, Supplier<CompletableFuture<Void>> runnable) {
        ServerWorld world = (ServerWorld)this.getLightEngine().getWorld();
        IChunk center = this.getLightEngine().getAnyChunkNow(chunkX, chunkZ);
        if (center == null || !center.func_201589_g().func_209003_a(ChunkStatus.field_222614_j)) {
            return;
        }
        if (center.func_201589_g() != ChunkStatus.field_222617_m) {
            runnable.get();
            return;
        }
        if (!world.func_72863_F().field_217237_a.field_219257_k.func_213162_bc()) {
            world.func_72863_F().field_217237_a.field_219257_k.execute(() -> this.queueTaskForSection(chunkX, chunkY, chunkZ, runnable));
            return;
        }
        long key = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        CompletableFuture<Void> updateFuture = runnable.get();
        if (updateFuture == null) {
            return;
        }
        int references = this.chunksBeingWorkedOn.addTo(key, 1);
        if (references == 0) {
            ChunkPos pos = new ChunkPos(chunkX, chunkZ);
            world.func_72863_F().func_217228_a(StarLightInterface.CHUNK_WORK_TICKET, pos, 0, (Object)pos);
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                ChunkHolder neighbour = world.func_72863_F().field_217237_a.func_219220_a(CoordinateUtils.getChunkKey(dx + chunkX, dz + chunkZ));
                if (neighbour == null) continue;
                neighbour.field_219315_j = neighbour.field_219315_j.thenCombine(updateFuture, (curr, ignore) -> curr);
            }
        }
        ((CompletableFuture)updateFuture.thenAcceptAsync(ignore -> {
            int newReferences = this.chunksBeingWorkedOn.get(key);
            if (newReferences == 1) {
                this.chunksBeingWorkedOn.remove(key);
                ChunkPos pos = new ChunkPos(chunkX, chunkZ);
                world.func_72863_F().func_217222_b(StarLightInterface.CHUNK_WORK_TICKET, pos, 0, (Object)pos);
            } else {
                this.chunksBeingWorkedOn.put(key, newReferences - 1);
            }
        }, (Executor)world.func_72863_F().field_217237_a.field_219257_k)).whenComplete((ignore, thr) -> {
            if (thr != null) {
                field_215604_a.fatal("Failed to remove ticket level for post chunk task " + new ChunkPos(chunkX, chunkZ), thr);
            }
        });
    }

    @Overwrite
    public void func_215568_a(BlockPos pos) {
        BlockPos posCopy = pos.func_185334_h();
        this.queueTaskForSection(posCopy.func_177958_n() >> 4, posCopy.func_177956_o() >> 4, posCopy.func_177952_p() >> 4, () -> this.getLightEngine().blockChange(posCopy));
    }

    @Overwrite
    public void func_215581_a(ChunkPos pos) {
    }

    @Overwrite
    public void func_215566_a(SectionPos pos, boolean notReady) {
        this.queueTaskForSection(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), () -> this.getLightEngine().sectionChange(pos, notReady));
    }

    @Overwrite
    public void func_215571_a(ChunkPos pos, boolean lightEnabled) {
    }

    @Overwrite
    public void func_215574_a(LightType lightType, SectionPos pos, NibbleArray nibbles, boolean trustEdges) {
    }

    @Overwrite
    public void func_223115_b(ChunkPos pos, boolean retainData) {
    }

    @Overwrite
    public CompletableFuture<IChunk> func_215593_a(IChunk chunk, boolean lit) {
        ChunkPos chunkPos = chunk.func_76632_l();
        return CompletableFuture.supplyAsync(() -> {
            Boolean[] emptySections = StarLightEngine.getEmptySectionsForChunk(chunk);
            if (!lit) {
                chunk.func_217305_b(false);
                this.getLightEngine().lightChunk(chunk, emptySections);
                chunk.func_217305_b(true);
            } else {
                this.getLightEngine().forceLoadInChunk(chunk, emptySections);
                this.getLightEngine().checkChunkEdges(chunkPos.field_77276_a, chunkPos.field_77275_b);
            }
            this.field_215607_d.func_219209_c(chunkPos);
            return chunk;
        }, runnable -> {
            this.getLightEngine().scheduleChunkLight(chunkPos, runnable);
            this.func_215588_z_();
        }).whenComplete((c, throwable) -> {
            if (throwable != null) {
                field_215604_a.fatal("Failed to light chunk " + chunkPos, throwable);
            }
        });
    }
}

