/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.mixin.common.lightengine;

import ca.spottedleaf.starlight.common.chunk.ExtendedChunk;
import ca.spottedleaf.starlight.common.light.SWMRNibbleArray;
import ca.spottedleaf.starlight.common.light.StarLightEngine;
import ca.spottedleaf.starlight.common.light.StarLightInterface;
import ca.spottedleaf.starlight.common.light.StarLightLightingProvider;
import ca.spottedleaf.starlight.common.util.CoordinateUtils;
import ca.spottedleaf.starlight.common.util.WorldUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.lighting.ILightListener;
import net.minecraft.world.lighting.IWorldLightListener;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.lighting.WorldLightManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldLightManager.class})
public abstract class WorldLightManagerMixin
implements ILightListener,
StarLightLightingProvider {
    @Shadow
    @Nullable
    private LightEngine<?, ?> field_215576_a;
    @Shadow
    @Nullable
    private LightEngine<?, ?> field_215577_b;
    @Unique
    protected StarLightInterface lightEngine;
    @Unique
    protected final Long2ObjectOpenHashMap<SWMRNibbleArray[]> blockLightMap = new Long2ObjectOpenHashMap();
    @Unique
    protected final Long2ObjectOpenHashMap<SWMRNibbleArray[]> skyLightMap = new Long2ObjectOpenHashMap();

    @Override
    public final StarLightInterface getLightEngine() {
        return this.lightEngine;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void construct(IChunkLightProvider provider, boolean hasBlockLight, boolean hasSkyLight, CallbackInfo ci) {
        this.lightEngine = new StarLightInterface(provider, hasSkyLight, hasBlockLight);
        this.field_215576_a = null;
        this.field_215577_b = null;
    }

    @Overwrite
    public void func_215568_a(BlockPos pos) {
        this.lightEngine.blockChange(pos.func_185334_h());
    }

    @Overwrite
    public void func_215573_a(BlockPos pos, int level) {
    }

    @Overwrite
    public boolean func_215570_a() {
        return this.lightEngine.hasUpdates();
    }

    @Overwrite
    public int func_215575_a(int maxUpdateCount, boolean doSkylight, boolean skipEdgeLightPropagation) {
        boolean hadUpdates = this.func_215570_a();
        this.lightEngine.propagateChanges();
        return hadUpdates ? 1 : 0;
    }

    @Overwrite
    public void func_215566_a(SectionPos pos, boolean notReady) {
        this.lightEngine.sectionChange(pos, notReady);
    }

    @Overwrite
    public void func_215571_a(ChunkPos pos, boolean lightEnabled) {
    }

    @Overwrite
    public IWorldLightListener func_215569_a(LightType lightType) {
        return lightType == LightType.BLOCK ? this.lightEngine.getBlockReader() : this.lightEngine.getSkyReader();
    }

    @Overwrite
    public void func_215574_a(LightType lightType, SectionPos pos, NibbleArray nibble, boolean trustEdges) {
    }

    @Overwrite
    public void func_223115_b(ChunkPos pos, boolean retainData) {
    }

    @Overwrite
    public int func_227470_b_(BlockPos pos, int ambientDarkness) {
        int sky = this.lightEngine.getSkyReader().func_215611_b(pos) - ambientDarkness;
        int block = this.lightEngine.getBlockReader().func_215611_b(pos);
        return Math.max(sky, block);
    }

    @Override
    public void clientUpdateLight(LightType lightType, SectionPos pos, @Nullable NibbleArray nibble, boolean trustEdges) {
        if (this.getClass() != WorldLightManager.class) {
            throw new IllegalStateException("This hook is for the CLIENT ONLY");
        }
        IChunk chunk = this.getLightEngine().getAnyChunkNow(pos.func_177958_n(), pos.func_177952_p());
        switch (lightType) {
            case BLOCK: {
                SWMRNibbleArray[] blockNibbles = (SWMRNibbleArray[])this.blockLightMap.computeIfAbsent(CoordinateUtils.getChunkKey(pos), keyInMap -> StarLightEngine.getFilledEmptyLight(this.lightEngine.getWorld()));
                blockNibbles[pos.func_177956_o() - WorldUtil.getMinLightSection((World)this.lightEngine.getWorld())] = SWMRNibbleArray.fromVanilla(nibble);
                if (chunk == null) break;
                ((ExtendedChunk)chunk).setBlockNibbles(blockNibbles);
                this.lightEngine.getLightAccess().func_217201_a(LightType.BLOCK, pos);
                break;
            }
            case SKY: {
                SWMRNibbleArray[] skyNibbles = (SWMRNibbleArray[])this.skyLightMap.computeIfAbsent(CoordinateUtils.getChunkKey(pos), keyInMap -> StarLightEngine.getFilledEmptyLight(this.lightEngine.getWorld()));
                skyNibbles[pos.func_177956_o() - WorldUtil.getMinLightSection((World)this.lightEngine.getWorld())] = SWMRNibbleArray.fromVanilla(nibble);
                if (chunk == null) break;
                ((ExtendedChunk)chunk).setSkyNibbles(skyNibbles);
                this.lightEngine.getLightAccess().func_217201_a(LightType.SKY, pos);
                break;
            }
        }
    }

    @Override
    public void clientRemoveLightData(ChunkPos chunkPos) {
        if (this.getClass() != WorldLightManager.class) {
            throw new IllegalStateException("This hook is for the CLIENT ONLY");
        }
        this.blockLightMap.remove(CoordinateUtils.getChunkKey(chunkPos));
        this.skyLightMap.remove(CoordinateUtils.getChunkKey(chunkPos));
    }

    @Override
    public void clientChunkLoad(ChunkPos pos, Chunk chunk) {
        if (this.getClass() != WorldLightManager.class) {
            throw new IllegalStateException("This hook is for the CLIENT ONLY");
        }
        long key = CoordinateUtils.getChunkKey(pos);
        SWMRNibbleArray[] blockNibbles = (SWMRNibbleArray[])this.blockLightMap.get(key);
        SWMRNibbleArray[] skyNibbles = (SWMRNibbleArray[])this.skyLightMap.get(key);
        if (blockNibbles != null) {
            ((ExtendedChunk)chunk).setBlockNibbles(blockNibbles);
        }
        if (skyNibbles != null) {
            ((ExtendedChunk)chunk).setSkyNibbles(skyNibbles);
        }
    }
}

