/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl.config;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.impl.config.ConfigEntry;
import net.minecraft.util.ResourceLocation;

public enum PluginConfig implements IPluginConfig
{
    INSTANCE;

    static final Path PATH;
    static final Gson GSON;
    private final Map<ResourceLocation, ConfigEntry> configs = new HashMap<ResourceLocation, ConfigEntry>();

    public void addConfig(ConfigEntry entry) {
        this.configs.put(entry.getId(), entry);
    }

    @Override
    public Set<ResourceLocation> getKeys(String namespace) {
        return this.getKeys().stream().filter(id -> id.func_110624_b().equals(namespace)).collect(Collectors.toSet());
    }

    @Override
    public Set<ResourceLocation> getKeys() {
        return this.configs.keySet();
    }

    @Override
    public boolean get(ResourceLocation key, boolean defaultValue) {
        ConfigEntry entry = this.configs.get(key);
        return entry == null ? defaultValue : entry.getValue();
    }

    public Set<ConfigEntry> getSyncableConfigs() {
        return this.configs.values().stream().filter(ConfigEntry::isSynced).collect(Collectors.toSet());
    }

    public List<String> getNamespaces() {
        return this.configs.keySet().stream().map(ResourceLocation::func_110624_b).distinct().sorted((o1, o2) -> o1.equals("waila") ? -1 : (o2.equals("waila") ? 1 : o1.compareToIgnoreCase((String)o2))).collect(Collectors.toList());
    }

    public ConfigEntry getEntry(ResourceLocation key) {
        return this.configs.get(key);
    }

    public void set(ResourceLocation key, boolean value) {
        ConfigEntry entry = this.configs.get(key);
        if (entry != null) {
            entry.setValue(value);
        }
    }

    public void reload() {
        if (!Files.exists(PATH, new LinkOption[0])) {
            this.writeConfig(true);
        } else {
            Map config;
            try (BufferedReader reader = Files.newBufferedReader(PATH, StandardCharsets.UTF_8);){
                config = (Map)GSON.fromJson((Reader)reader, new TypeToken<Map<String, Map<String, Boolean>>>(){}.getType());
            }
            catch (IOException e) {
                config = Maps.newHashMap();
            }
            if (config == null) {
                this.writeConfig(true);
            } else {
                config.forEach((namespace, subMap) -> subMap.forEach((path, value) -> this.set(new ResourceLocation(namespace, path), (boolean)value)));
            }
        }
    }

    public void save() {
        this.writeConfig(false);
    }

    private void writeConfig(boolean reset) {
        HashMap config = Maps.newHashMap();
        this.configs.values().forEach(e -> {
            Map modConfig = config.computeIfAbsent(e.getId().func_110624_b(), k -> Maps.newHashMap());
            if (reset) {
                e.setValue(e.getDefaultValue());
            }
            modConfig.put(e.getId().func_110623_a(), e.getValue());
        });
        try {
            String json = GSON.toJson((Object)config);
            Path parent = PATH.getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            BufferedWriter writer = Files.newBufferedWriter(PATH, StandardCharsets.UTF_8, new OpenOption[0]);
            writer.write(json);
            writer.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    static {
        PATH = Waila.configDir.resolve("waila/waila_plugins.json");
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }
}

