/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import com.google.gson.Gson;
import java.util.Map;
import java.util.function.Consumer;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.impl.config.PluginConfig;
import mcp.mobius.waila.overlay.DataAccessor;
import mcp.mobius.waila.overlay.TooltipRegistrar;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class PacketExecutor {
    private static final Gson GSON = new Gson();

    public static void receiveData(CompoundNBT tag) {
        DataAccessor.INSTANCE.setServerData(tag);
    }

    public static void sendConfig(Map<ResourceLocation, Boolean> map) {
        PluginConfig.INSTANCE.getSyncableConfigs().forEach(config -> config.setValue(map.getOrDefault(config.getId(), config.getDefaultValue())));
        Waila.LOGGER.info("Received config from the server: {}", (Object)GSON.toJson(map));
    }

    public static void requestEntity(ServerPlayerEntity player, int entityId, Consumer<CompoundNBT> consumer) {
        TooltipRegistrar registrar = TooltipRegistrar.INSTANCE;
        World world = player.field_70170_p;
        Entity entity = world.func_73045_a(entityId);
        if (entity == null) {
            return;
        }
        CompoundNBT tag = new CompoundNBT();
        registrar.entityData.get(entity).forEach(provider -> provider.appendServerData(tag, player, world, entity));
        tag.func_74768_a("WailaEntityID", entity.func_145782_y());
        consumer.accept(tag);
    }

    public static void requestBlockEntity(ServerPlayerEntity player, BlockPos pos, Consumer<CompoundNBT> consumer) {
        TooltipRegistrar registrar = TooltipRegistrar.INSTANCE;
        World world = player.field_70170_p;
        if (!world.func_175667_e(pos)) {
            return;
        }
        TileEntity blockEntity = world.func_175625_s(pos);
        if (blockEntity == null) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        CompoundNBT tag = new CompoundNBT();
        registrar.blockData.get(blockEntity).forEach(provider -> provider.appendServerData(tag, player, world, blockEntity));
        registrar.blockData.get(state.func_177230_c()).forEach(provider -> provider.appendServerData(tag, player, world, blockEntity));
        tag.func_74768_a("x", pos.func_177958_n());
        tag.func_74768_a("y", pos.func_177956_o());
        tag.func_74768_a("z", pos.func_177952_p());
        tag.func_74778_a("id", Registry.field_212626_o.func_177774_c((Object)blockEntity.func_200662_C()).toString());
        consumer.accept(tag);
    }
}

