/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import mcp.mobius.waila.api.impl.config.ConfigEntry;
import mcp.mobius.waila.api.impl.config.PluginConfig;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public abstract class PacketIo<I, O> {
    public static final PacketIo<CompoundNBT, CompoundNBT> ReceiveData = new PacketIo<CompoundNBT, CompoundNBT>(){

        @Override
        public void write(PacketBuffer buf, CompoundNBT tag) {
            buf.func_150786_a(tag);
        }

        @Override
        protected CompoundNBT apply(PacketBuffer buf) {
            return buf.func_150793_b();
        }
    };
    public static final PacketIo<Entity, Integer> RequestEntity = new PacketIo<Entity, Integer>(){

        @Override
        public void write(PacketBuffer buf, Entity entity) {
            buf.writeInt(entity.func_145782_y());
        }

        @Override
        protected Integer apply(PacketBuffer buf) {
            return buf.readInt();
        }
    };
    public static final PacketIo<TileEntity, BlockPos> RequestBlock = new PacketIo<TileEntity, BlockPos>(){

        @Override
        public void write(PacketBuffer buf, TileEntity blockEntity) {
            buf.func_179255_a(blockEntity.func_174877_v());
        }

        @Override
        protected BlockPos apply(PacketBuffer buf) {
            return buf.func_179259_c();
        }
    };
    public static final PacketIo<PluginConfig, Map<ResourceLocation, Boolean>> SendConfig = new PacketIo<PluginConfig, Map<ResourceLocation, Boolean>>(){

        @Override
        public void write(PacketBuffer buf, PluginConfig config) {
            Set<ConfigEntry> entries = config.getSyncableConfigs();
            buf.writeInt(entries.size());
            entries.forEach(e -> {
                buf.writeInt(e.getId().toString().length());
                buf.func_180714_a(e.getId().toString());
                buf.writeBoolean(e.getValue());
            });
        }

        @Override
        protected Map<ResourceLocation, Boolean> apply(PacketBuffer buf) {
            int size = buf.readInt();
            HashMap<ResourceLocation, Boolean> map = new HashMap<ResourceLocation, Boolean>();
            for (int j = 0; j < size; ++j) {
                int idLength = buf.readInt();
                ResourceLocation id = new ResourceLocation(buf.func_150789_c(idLength));
                boolean value = buf.readBoolean();
                map.put(id, value);
            }
            return map;
        }
    };

    public abstract void write(PacketBuffer var1, I var2);

    public PacketBuffer create(I i) {
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        this.write(buf, i);
        return buf;
    }

    protected abstract O apply(PacketBuffer var1);

    public <R> R apply(PacketBuffer buf, Function<O, R> fun) {
        return fun.apply(this.apply(buf));
    }

    public void consume(PacketBuffer buf, Consumer<O> fun) {
        fun.accept(this.apply(buf));
    }
}

